#ifndef INCL_KEYCLASS_H
#define INCL_KEYCLASS_H

// *-----------------------------------------------------------------------
// * Xclasses class header file
// * 
// * class name: keyclass
// * author    : Jrgen Schmitz
// * version   : 1.0
// *-----------------------------------------------------------------------

#include <Xclasses/types.h>
#include <Xclasses/Xwindows.h>
#include <Xclasses/gadget.h>
#include <X11/keysym.h>
#include <X11/keysymdef.h>

#define KEY_NONE	0
#define KEY_SHIFT	1
#define KEY_CONTROL	2
#define KEY_ALT		4

class keyclass : public Xclasses
{
	friend class pkeyclass;

	class pkeyclass *p;
public:
    keyclass(class Xwindows *);
    virtual ~keyclass(void);

	void operator=(keyclass *);
	void operator=(keyclass &); // e.g. *x1=*x2!!!

	void FreeKey(unsigned int xkey,unsigned int qual);
	void FreeKey(char *key,unsigned int qual);	

	void SendActivateTo(unsigned int xkey,unsigned int qual,gadget *);
	void SendActivateTo(unsigned int xkey,unsigned int qual,gadget &g) { SendActivateTo(xkey,qual,&g); }
	void SendActivateTo(char *key,unsigned int qual,gadget *);
	void SendActivateTo(char *key,unsigned int qual,gadget &g) { SendActivateTo(key,qual,&g); }
	
	void SendSelectTo(unsigned int xkey,unsigned int qual,gadget *);
	void SendSelectTo(unsigned int xkey,unsigned int qual,gadget &g) { SendSelectTo(xkey,qual,&g); }
	void SendSelectTo(char *key,unsigned int qual,gadget *);
	void SendSelectTo(char *key,unsigned int qual,gadget &g) { SendSelectTo(key,qual,&g); }

	void SendKeyTo(unsigned int xkey,unsigned int qual,gadget *);
	void SendKeyTo(unsigned int xkey,unsigned int qual,gadget &g) { SendKeyTo(xkey,qual,&g); }
	void SendKeyTo(char *key,unsigned int qual,gadget *);
	void SendKeyTo(char *key,unsigned int qual,gadget &g) { SendKeyTo(key,qual,&g); }

	void SendHookTo(unsigned int xkey,unsigned int qual,void h(XEvent *,KeySym,char *,int),int userdata);
	void SendHookTo(char *key,unsigned int qual,void h(XEvent *,KeySym,char *,int),int userdata);
	void SendHookTo(unsigned int xkey,unsigned int qual,void *hclass,void h(XEvent *,KeySym,char *,int),int userdata);
	void SendHookTo(unsigned int xkey,unsigned int qual,void *hclass,...);
	void SendHookTo(char *key,unsigned int qual,void *hclass,void h(XEvent *,KeySym,char *,int),int userdata);
	void SendHookTo(char *key,unsigned int qual,void *hclass,...);


// Hook is: int h(XEvent *,KeySym,char *,int) !
	void SendHookSelectTo(unsigned int xkey,unsigned int qual,gadget *,void h(XEvent *,KeySym,char *,int),int userdata);
	void SendHookSelectTo(unsigned int xkey,unsigned int qual,gadget &,void h(XEvent *,KeySym,char *,int),int userdata);
	void SendHookSelectTo(char *key,unsigned int qual,gadget *,void h(XEvent *,KeySym,char *,int),int userdata);
	void SendHookSelectTo(char *key,unsigned int qual,gadget &,void h(XEvent *,KeySym,char *,int),int userdata);
	void SendHookSelectTo(unsigned int xkey,unsigned int qual,gadget *,void *hclass,...);
	void SendHookSelectTo(unsigned int xkey,unsigned int qual,gadget &,void *hclass,...);
	void SendHookSelectTo(char *key,unsigned int qual,gadget *,void *hclass,...);
	void SendHookSelectTo(char *key,unsigned int qual,gadget &,void *hclass,...);
};

#endif
