#ifndef DESIGNER_H
#define DESIGNER_H

#include <Xclasses/Xclasses.h>

#define TEXTLEN		200
#define INTERNLEN	50
#define INTLEN		4

struct des_button
{
	char	text[TEXTLEN];
};
int ed_button(int,struct des_object *);
struct des_fbutton
{
	char	text[TEXTLEN];
};
int ed_fbutton(int,struct des_object *);
struct des_selbutton
{
	char	text[TEXTLEN];
};
int ed_selbutton(int,struct des_object *);
struct des_mxbutton
{
	char	**text;
};
int ed_mxbutton(int,struct des_object *);
struct des_selknob
{
	char	text[TEXTLEN];
};
int ed_selknob(int,struct des_object *);
struct des_mxknob
{
	char	**text;
};
int ed_mxknob(int,struct des_object *);
struct des_checkbox
{
	char	text[TEXTLEN];
};
int ed_checkbox(int,struct des_object *);
struct des_xclock
{
	int		showseconds;
	int		exactminutes;
	int		smallseconds;
	int		nominutes;	
};
int ed_xclock(int,struct des_object *);
struct des_scroller
{
	int		visible;
	int		items;
	int		arrows;
	int		horiz;
};
int ed_scroller(int,struct des_object *);
struct des_slider
{
	int		minval;
	int		maxval;
	int		horiz;
};
int ed_slider(int,struct des_object *);
struct des_listview
{
	int		readonly;
	int		showselected;
	int		multiselect;
	int		multidirect;
};
int ed_listview(int,struct des_object *);
struct des_input
{
	int		maxchars;
	int		alwaysmode;
	int		integermode;
	int		invisiblemode;
	char	text[TEXTLEN];
};
int ed_input(int,struct des_object *);
struct des_indicator
{
	int		circle;
	char	title[TEXTLEN];
};
int ed_indicator(int,struct des_object *);
struct des_choice
{
	char	**text;
};
int ed_choice(int,struct des_object *);
struct des_text
{
	char	adjust;
	char	text[TEXTLEN];
};
int ed_text(int,struct des_object *);
struct des_textbox
{
	int alwayslast;
};
int ed_textbox(int,struct des_object *);
struct des_autotextbox
{
	int alwayslast;
};
int ed_autotextbox(int,struct des_object *);
struct des_htmltextbox
{
	int alwayslast;
};
int ed_htmltextbox(int,struct des_object *);
struct des_output
{
	char	text[TEXTLEN];
};
int ed_output(int,struct des_object *);
struct des_graphic
{
	int		width;
	int		height;
};
int ed_graphic(int,struct des_object *);
struct des_image
{

};
int ed_image(int,struct des_object *);

struct des_ruler
{
	int		space;
	int		offset;
	int		horiz;
};
int ed_ruler(int,struct des_object *);

struct des_visible
{
	gadget	*gg;
};
int ed_visible(int,struct des_object *);
struct des_card
{
	char	title[50][INTERNLEN];
	group	*gp[50];
};
int ed_card(int,struct des_object *);

struct des_rubbergroup
{
	char	title[50][INTERNLEN];
	group	*gp[50];
};
int ed_rubbergroup(int,struct des_object *);

struct des_group
{
};
int ed_group(int,struct des_object *);
struct des_bordergroup
{
	char	title[TEXTLEN];
};
int ed_bordergroup(int,struct des_object *);
struct des_spacegroup
{
	int		space;
};
int ed_spacegroup(int,struct des_object *);

#define	OBJ_ALLGROUPS	0x80000000
#define OBJ_GROUP		(OBJ_ALLGROUPS|1)
#define OBJ_BORDERGROUP	(OBJ_ALLGROUPS|2)
#define OBJ_SPACEGROUP	(OBJ_ALLGROUPS|3)

#define OBJ_BUTTON		1
#define OBJ_FBUTTON		2
#define OBJ_SELBUTTON	3
#define OBJ_MXBUTTON	4
#define OBJ_SELKNOB		5
#define OBJ_MXKNOB		6
#define OBJ_CHECKBOX	7
#define OBJ_CHOICE		8
#define OBJ_LISTVIEW	9
#define OBJ_INPUT		10
#define OBJ_SLIDER		11
#define OBJ_SCROLLER	12
#define OBJ_TEXTBOX		13

#define	OBJ_ALLAGGS		0x00800000
#define OBJ_VISIBLE		(OBJ_ALLAGGS|1)
#define	OBJ_ALLAGPS		0x08000000
#define OBJ_CARD		(OBJ_ALLAGPS|1)
#define OBJ_RUBBERGROUP	(OBJ_ALLAGPS|2)

#define OBJ_XCLOCK		101
#define OBJ_INDICATOR	102
#define OBJ_OUTPUT		103
#define OBJ_TEXT		104
#define OBJ_RULER		105
#define OBJ_GRAPHIC		106
#define OBJ_IMAGE		107
#define OBJ_AUTOTEXTBOX	108
#define OBJ_HTMLTEXTBOX	109

#define TOTAL_GROUPS	3
#define TOTAL_GADGETS	13
#define TOTAL_OUTPUT	9
#define TOTAL_ADDGGS	1
#define TOTAL_ADDGPS	2
#define TOTAL_OBJ		(TOTAL_GROUPS+TOTAL_GADGETS+TOTAL_OUTPUT+TOTAL_ADDGPS+TOTAL_ADDGGS)


struct des_object
{
	node			base;
	unsigned int	type;
	unsigned int	size;
	int				level;
	gadget			*obj;
	lefttext		*ltobj;
	char			classname[50];
	char			lvtext[150];
	char			helpinfo[220];
	int				func;

// Object Data
	char			varname[INTERNLEN];
	char			objname[INTERNLEN];
	int				weight;
	int				gp_dialogmode:1,
					gp_usesmallest:1,
					gg_lefttext:1,
					gp_horiz:1,
					gp_free:1;
	short			gp_adjust;
	char			lttext[TEXTLEN];
	char			ID[INTERNLEN];
	char			callback[INTERNLEN];
	char			*helptext;
	union
	{
		des_group			d_group;
		des_bordergroup		d_bordergroup;
		des_spacegroup		d_spacegroup;
		des_button			d_button;
		des_fbutton			d_fbutton;
		des_selbutton		d_selbutton;
		des_mxbutton		d_mxbutton;
		des_selknob			d_selknob;	// don't use
		des_mxknob			d_mxknob;
		des_checkbox		d_checkbox;
		des_input			d_input;
		des_listview		d_listview;
		des_choice			d_choice;
		des_slider			d_slider;
		des_scroller		d_scroller;
		des_xclock			d_xclock;
		des_output			d_output;
		des_indicator		d_indicator;
		des_ruler			d_ruler;
		des_text			d_text;
		des_textbox			d_textbox;
		des_autotextbox		d_autotextbox;
		des_htmltextbox		d_htmltextbox;
		des_graphic			d_graphic;
		des_image			d_image;
		des_visible			d_visible;
		des_card			d_card;
		des_rubbergroup		d_rubbergroup;
	};
	char			*outputbuf;
};

#define MODE_CREATE		1
#define MODE_FREE		2
#define MODE_COMMAND	3
#define MODE_SETUP		4

#define CP_MAKEGROUP	1
#define CP_SETVALUES	2
#define CP_EXPORT		3

struct functions
{
	int (*func)(int, struct des_object *);
	char *name;
	int count;
	char vars[80];
};

struct settings
{
	char	funcname[40];
	char	objprefixes[10];
	int		genmain;
};

#endif
