#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>

#include <Xclasses/Xclasses.h>

XCprogram	myprg("designer",
					XCP_Version,"0.4beta",
					XCP_Copyright,"(c) by Jrgen Schmitz 1996/1997",
					XCP_Author,"Jrgen Schmitz",
					XCP_Desc,"A GUI design tool for Xclasses",
					XCP_EMail,"schmitzj@fsai.fh-trier.de",
					XCP_WWW,"http://fsai.fh-trier.de/~schmitzj/Xclasses/",
					XCP_OwnHTML,
			"This program may be used and copied along with the "
			"Xclasses layout library and its documentation!"
		,
					XCP_XC_logo,
					XCP_Done);

#include "designer.h"
#include "externs.h"

appwindow mainwin,testwin;
group maingp;
bordergroup gadgetlist,addgr;
group listcontrol;
file_dialog filedial,expdial;

listview allgadgets,addlist;
fbutton ag_up,ag_down,ag_remove,ag_edit,ag_levelup,ag_leveldown;
fbutton ad_add;

menu mymenu;

int lv_hook(struct hook_data *hd)
{
	des_object *o=(des_object*)hd->itemdata;
	for(int i=-4;i<=hd->x+o->level*8-4;i+=8)
		XDrawLine(hd->drawable->display(),hd->drawable->gg_win(),hd->drawable->gg_gc(),
					i,hd->y,i,hd->y+hd->height-1);
	return o->level*8;
}

int showExample(void)
{
	group *gr=showgg();
	if (gr)
	{
		testwin.Init();
		testwin.SetGroup(gr);
		testwin.Create();
	}
	else
	{
		easy_dialog error;
		error.Options("OK");
		error.Text("Error:\nCan't create groups & gadgets.");
		error.Start(mainwin);
	}
	return (int)gr;
}
void closeExample(void)
{
	testwin.Close();
	freegg();
}
struct settings set={"genGUI","",0,};
void settings(void)
{
	int x,y,w,h,r=0;
	appwindow owin;
	group mgp;
	card mc;
	fbutton ok;
	group pregp,savegp;

	mainwin.Position(x,y);
	mainwin.Size(w,h);
	owin.InitSize(10,10,40);
	owin.Init();
	owin.TransientFor(mainwin);
	owin.Adjust(x,y,w,h,ADJUST_CENTER|ADJUST_MIDDLE);

	mgp.Vert();
	mgp.Add(mc);
	mgp.Add(ok);
	 ok.Text("Close");
	 ok.ID(1);

	mc.Add("Names & Prefixes",pregp);
	mc.Add("Export settings",savegp);

	input funcname,objpref;
	pregp.Vert();
	pregp.Add(funcname);
	 funcname.Text("Function name");
	 funcname.MaxChars(sizeof(set.funcname));
	 funcname.Default(set.funcname);
	pregp.Add(objpref);
	 objpref.Text("Object prefix");
	 objpref.MaxChars(sizeof(set.objprefixes));
	 objpref.Default(set.objprefixes);

	checkbox genMain;
	savegp.Vert();
	savegp.Add(genMain);
	 genMain.State(set.genmain?PRESSED:RELEASED);
	 genMain.Text("export as main program");

	owin.SetGroup(mgp);
	owin.Create();
	mgp.IgnoreExcept(owin.window());
	while (!r)
	{
		h=owin.NextEvent();
		if (h==EV_WINDOWCLOSE)
		{
			r=1;
		}
		else if (h==EV_GADGET)
		{
			switch (owin.ID())
			{
				case 1:
					r=1;
					break;
			}
		}
	}
	mgp.IgnoreNothing();
	owin.Close();
	set.genmain=genMain.State()==PRESSED;
	funcname.Input(set.funcname);
	objpref.Input(set.objprefixes);
}
int handleMenu(void)
{
	int r=0;
	switch (mymenu.Selection())
	{
		case 0x01000001: // new
			break;
		case 0x01000002: // load
			filedial.LoadMode();
			if (filedial.Start(mainwin))
			{
			}
			break;
		case 0x01000003: // save
			break;
		case 0x01000004: // save as
			filedial.SaveMode();
			if (filedial.Start(mainwin))
			{
			}
			break;
		case 0x01000005: // export
			expdial.SaveMode();
			if (expdial.Start(mainwin))
			{
				char buf[700],f[260];
				expdial.GetDir(buf,sizeof(buf));
				expdial.GetFile(f,sizeof(f));
				strcat(buf,f);
				exportgg(buf);
			}
			break;
		case 0x01000006: // quit
			r=1;
			break;
		case 0x02000001: // show
			if (mymenu.State(2,1)==PRESSED)
			{
				listcontrol.Lock();
				allgadgets.Lock();
				addgr.Lock();
				if (!showExample())
				{
					addgr.Unlock();
					allgadgets.Unlock();
					listcontrol.Unlock();
					mymenu.State(2,1,RELEASED);
				}
			}
			else
			{
				closeExample();
				addgr.Unlock();
				allgadgets.Unlock();
				listcontrol.Unlock();
			}
			break;
		case 0x02000002: // name & prefix
			settings();
			break;
	}
	return r;
}
void checklocks(void)
{
	if (addlist.Selected()==0)
	{
		ad_add.Lock();
	}
	if (allgadgets.Selected()==0)
	{
		listcontrol.Lock();
	}
	if (allgadgets.Count()==0)
	{
		mymenu.LockItem(1,3);
		mymenu.LockItem(1,4);
		mymenu.LockItem(1,5);
	}
}
void updateOutput(int force=0)
{
	des_object *o;
	char buf[sizeof(o->lvtext)+50];
	int grouplevel=0;
	int c=0,t=allgadgets.Count();

	o=(des_object *)allobjs.head;
	while (o->base.next)
	{
		strcpy(buf,o->lvtext);
		o->lvtext[0]=0;
//		for(int i=0;i<o->level;i++)
//		{
//			o->lvtext[i]=' ';
//			o->lvtext[i+1]=0;
//		}
		if (o->objname[0])
			strcat(o->lvtext,o->objname);
		else
			strcat(o->lvtext,o->varname);
		if (o->level>grouplevel)
		{
			strcat(o->lvtext," *** Level error ***");
		}
		strcat(o->lvtext," (");
		strcat(o->lvtext,o->classname);
		strcat(o->lvtext,")");
		if (o->level<grouplevel) grouplevel=o->level;
		if (o->type & OBJ_ALLGROUPS) grouplevel=o->level+1;
		if (c<t)
		{
			if (force || strcmp(buf,o->lvtext)) allgadgets.Replace(c+1,o->lvtext);
			allgadgets.ChangeData(c+1,o);
		}
		else
		{
			allgadgets.AddAtEnd(o->lvtext,o);
		}
		c++;
		o=(des_object*)o->base.next;
	}
	if (c<=t)
	{
		allgadgets.Remove(c+1,t);
	}
}
void leveldown(void)
{
	des_object *obj;
	obj=(des_object*)allgadgets.GetData(allgadgets.Selected());

	if (obj->base.prev->prev &&
		(((((des_object*)obj->base.prev)->type & OBJ_ALLGROUPS) && ((des_object*)obj->base.prev)->level>=obj->level) ||
		((des_object*)obj->base.prev)->level>obj->level))
	{
		if (obj->type & OBJ_ALLGROUPS)
		{
			des_object *o=obj;
			o=(des_object*)o->base.next;
			while (o->base.next && o->level>obj->level)
			{
				o->level++;
				o=(des_object*)o->base.next;
			}
			obj->level++;
		}
		else
		{
			obj->level++;
		}

		updateOutput();
		allgadgets.Selected(allobjs.Find((node*)obj));
	}
}
void levelup(void)
{
	des_object *obj;
	obj=(des_object*)allgadgets.GetData(allgadgets.Selected());

	if (obj->type & OBJ_ALLGROUPS)
	{
		des_object *o=obj;
		o=(des_object*)o->base.next;
		while (o->base.next && o->level>obj->level)
		{
			if (o->level>0) o->level--;
			o=(des_object*)o->base.next;
		}
		obj->level--;
	}
	else
	{
		if (obj->level>0) obj->level--;
	}

	updateOutput();
	allgadgets.Selected(allobjs.Find((node*)obj));
}
void moveup(void)
{
	des_object *obj;
	des_object *o;
	obj=(des_object*)allgadgets.GetData(allgadgets.Selected());
	if (!obj->base.prev->prev) return;

	o=(des_object*)obj->base.prev;
	while (o->base.prev && o->level>obj->level)
	{
		o=(des_object *)o->base.prev;
	}
	if (!o->base.prev) return;

	if (obj->type & OBJ_ALLGROUPS)
	{
		des_object *o2=(des_object*)obj->base.next,*o3;
		allobjs.Remove((node*)obj);
		allobjs.Insert((node*)obj,(node*)o);
		while (o2->base.next && o2->level>obj->level)
		{
			o3=(des_object*)o2->base.next;
			allobjs.Remove((node*)o2);
			allobjs.Insert((node*)o2,(node*)o);
			o2=o3;
		}
	}
	else
	{
		allobjs.Remove((node*)obj);
		allobjs.Insert((node*)obj,(node*)o);
	}
	updateOutput(1);
	allgadgets.Selected(allobjs.Find((node*)obj));
}
void movedown(void)
{
	des_object *obj;
	des_object *o;
	obj=(des_object*)allgadgets.GetData(allgadgets.Selected());
	if (!obj->base.next->next) return;

	o=(des_object*)obj->base.next;
	while (o->base.next && ((o->level==obj->level && o->type&OBJ_ALLGROUPS) || (o->level>obj->level)))
	{
		o=(des_object *)o->base.next;
	}

	if (o->base.next)
		o=(des_object*)o->base.next;

	if (obj->type & OBJ_ALLGROUPS)
	{
		des_object *o2=(des_object*)obj->base.next,*o3;
		allobjs.Remove((node*)obj);
		allobjs.Insert((node*)obj,(node*)o);
		while (o!=o2 && o2->base.next && o2->level>obj->level)
		{
			o3=(des_object*)o2->base.next;
			allobjs.Remove((node*)o2);
			allobjs.Insert((node*)o2,(node*)o);
			o2=o3;
		}
	}
	else
	{
		allobjs.Remove((node*)obj);
		allobjs.Insert((node*)obj,(node*)o);
	}
	updateOutput(1);
	allgadgets.Selected(allobjs.Find((node*)obj));
}
int main(int argc,char *argv[])
{
	int ende=0,w;

	mainwin.InitSize(0,0,100);
	if (!mainwin.Init(argc,argv))
	{
		printf("Error: Can't open display\n");
		exit(1);
	} 
	
	mainwin.Title("Xclasses Designer - (c) Jrgen Schmitz");
	mainwin.IconTitle("Xclasses Designer");
	mainwin.Class("designer","Designer");

	maingp.Horiz();
	 gadgetlist.Title("Gadgets");
	 gadgetlist.Horiz();
	 gadgetlist.Center();
	  allgadgets.ShowSelected();
	  allgadgets.ID(2);
	  allgadgets.Weight(130);
	  allgadgets.Font(FONT_FIXED);
	  allgadgets.SetHook(lv_hook,NULL);
	 gadgetlist.Add(allgadgets);
	  listcontrol.Vert();
	  listcontrol.Weight(30);
	   ag_up.Text("up");
	   ag_up.ID(3);
	  listcontrol.Add(ag_up);
	   ag_down.Text("down");
	   ag_down.ID(4);
	  listcontrol.Add(ag_down);
	   ag_levelup.Text("<-");
	   ag_levelup.ID(7);
	  listcontrol.Add(ag_levelup);
	   ag_leveldown.Text("->");
	   ag_leveldown.ID(8);
	  listcontrol.Add(ag_leveldown);
	   ag_remove.Text("remove");
	   ag_remove.ID(5);
	  listcontrol.Add(ag_remove);
	   ag_edit.Text("edit...");
	   ag_edit.ID(6);
	  listcontrol.Add(ag_edit);
	 gadgetlist.Add(listcontrol);
	maingp.Add(gadgetlist);
	 addgr.Title("Objects");
	 addgr.Vert();
	 addgr.Weight(60);
	  addlist.ShowSelected();
	  addlist.ID(10);
	  addlist.Weight(140);
	 addgr.Add(addlist);
	  ad_add.ID(11);
	  ad_add.Text("add...");
	  ad_add.Weight(10);
	 addgr.Add(ad_add);
	maingp.Add(addgr);

	mainwin.SetGroup(maingp);
	mymenu.ID(1);
	mymenu.AddMenu("File");
	mymenu.Add("New",1);
	mymenu.AddRuler();
	mymenu.Add("Load...","l",2);
	mymenu.Add("Save","s",3);
	mymenu.Add("Save as...","a",4);
	mymenu.AddRuler();
	mymenu.Add("Export...","x",5);
	mymenu.AddRuler();
	mymenu.Add("Quit","q",6);
	mymenu.AddMenu("Settings");
	mymenu.AddSel("Show window...","f1",1);
	mymenu.AddRuler();
	mymenu.Add("Name & prefixes...","f2",2);

	settypenames();
	mainwin.SetMenu(mymenu);
	mainwin.Create();
	checklocks();
	while (!ende)
	{
		w=mainwin.NextEvent();
		if (w==EV_WINDOWCLOSE)
		{
			if (mainwin.CloseMe()) ende=1;
			if (testwin.CloseMe())
			{
				closeExample();
				mymenu.State(2,1,RELEASED);
				addgr.Unlock();
				allgadgets.Unlock();
				listcontrol.Unlock();
			}
		}
		else if (w==EV_GADGET)
		{
			switch (mainwin.ID())
			{
				case 1: // Menu
					ende=handleMenu();
					checklocks();
					break;
				case 2: // gg list
					listcontrol.Unlock();
					if (mainwin.DoubleClick())
					{
						listcontrol.Lock();
						allgadgets.Lock();
						addgr.Lock();
						editgg();
						addgr.Unlock();
						allgadgets.Unlock();
						listcontrol.Unlock();
						checklocks();
					}
					break;
				case 3: // up
					moveup();
					break;
				case 4: // down
					movedown();
					break;
				case 5: // remove
					delgg();
					checklocks();
					break;
				case 6: // edit
					listcontrol.Lock();
					addgr.Lock();
					editgg();
					addgr.Unlock();
					listcontrol.Unlock();
					checklocks();
					break;
				case 7: // <-
					levelup();
					break;
				case 8: // ->
					leveldown();
					break;
				case 10: // ggs
					ad_add.Unlock();
					if (mainwin.DoubleClick())
					{
						listcontrol.Lock();
						allgadgets.Lock();
						addgr.Lock();
						addgg();
						addgr.Unlock();
						allgadgets.Unlock();
						listcontrol.Unlock();
						checklocks();
						mymenu.UnlockItem(1,3);
						mymenu.UnlockItem(1,4);
						mymenu.UnlockItem(1,5);
					}
					break;
				case 11: // add
					listcontrol.Lock();
					allgadgets.Lock();
					addgr.Lock();
					addgg();
					addgr.Unlock();
					allgadgets.Unlock();
					listcontrol.Unlock();
					checklocks();
					mymenu.UnlockItem(1,3);
					mymenu.UnlockItem(1,4);
					mymenu.UnlockItem(1,5);
					break;
			}
		}
	}
	if (mymenu.State(2,1)==PRESSED) closeExample();
	mainwin.Close();
}
