#ifndef INCL_MXGADGET_H
#define INCL_MXGADGET_H

// *-----------------------------------------------------------------------
// * Xclasses class header file
// * 
// * class name: mxgadget
// * author    : Jrgen Schmitz
// * version   : 1.0
// *-----------------------------------------------------------------------

#include <Xclasses/types.h>
#include <Xclasses/gadget.h>
#include <Xclasses/Ddraw.h>
#include <Xclasses/selgadget.h>

// macro to make an array of pointer to selgadget (x*)[]
// from selgadget array (x[])
// parameters:
//  var     - the selgadget array (e.g. selbutton b[5])
//  count   - number of objects   (e.g. 5)
//  array   - array to write into (e.g. selbutton *pb[6])
//            MUST have one field more!!
#define MakeItems(var,count,array) 	{ for(int i=0;i<count;i++) array[i]=&var[i]; array[count]=NULL; }

class mxgadget : Ddraw, public gadget
{
	friend class pmxgadget;
	
	class pmxgadget *p;

public:
    virtual void GExpose(XEvent *event);
    virtual void GActionPress(int mx,int my,int rx,int ry,unsigned int state,int button,int reason);
    virtual void GActionRelease(int mx,int my,int rx,int ry,unsigned int state,int button,int reason);
    virtual int GActivate(XEvent *event,int why);
    virtual int GSelected(XEvent *event,int why,int wasabove);
    virtual void GSetLimits(void);

public:
    mxgadget();
    virtual ~mxgadget();

    int Create(void);
    void Free(void);
    void Items(selgadget **ggs);
    void Horiz(void);
  
    void Selected(int n);
	int  Selected(void);
  
	void Resize(int w,int h);
    void Lock();
    void Unlock();
    void Block(int);
    void Unblock(int);

	void ManageOnly(void);
};

#endif
