#ifndef INCL_MULTILISTVIEW_H
#define INCL_MULTILISTVIEW_H

// *-----------------------------------------------------------------------
// * Xclasses class header file
// * 
// * class name: multilistview
// * author    : Jrgen Schmitz
// * version   : 1.0
// *-----------------------------------------------------------------------

#include <Xclasses/types.h>
#include <Xclasses/gadget.h>
#include <Xclasses/Xcolors.h>
#include <Xclasses/Ddraw.h>
#include <Xclasses/gfx_object.h>


class multilistview : Ddraw, public gadget 
{
	friend class pmultilistview;

	class pmultilistview *p;

public:
    virtual void GExpose(XEvent *event);
    virtual void GActionPress(int mx,int my,int rx,int ry,unsigned int state,int button,int reason);
    virtual void GActionRelease(int mx,int my,int rx,int ry,unsigned int state,int button,int reason);
    virtual int  GMouseMove(int mx,int my,int rx,int ry,unsigned int state,int button);
    virtual int  GActivate(XEvent *event,int why);
    virtual int  GSelected(XEvent *event,int why,int wasabove);
	virtual void GSetLimits(void);

	int visible_width(void);
	int visible_height(void);

public:
    multilistview();
    virtual ~multilistview();

    virtual int Create(void);
    virtual void Free(void);
	virtual void Resize(int w,int h);
	virtual void Lock(void);
	virtual void Unlock(void);
	virtual void Block(int);
	virtual void Unblock(int);

// before Create	
	void Columns(int,struct column_spec spec[]);

	void ShowSelected(void);
	void ReadOnly(void);
	void Spacing(int);

// before & after
	void ColumnConfigure(int col,struct column_spec *);

	void MultiSelect(void);
	void DirectMulti(void);
	void SingleSelect(void);

// item management
	void AddAtEnd(char **);
	void AddAtBegin(char **);
	void AddBefore(int,char **);

	void AddAtEnd(char **,void *data);
	void AddAtBegin(char **,void *data);
	void AddBefore(int,char **,void *data);

	void Remove(int);
	void Remove(int start,int end);
	void RemoveAll(void);
	void Replace(int,char **);
	void MoveLine(int,int);
	int Count();

	void *GetData(int);
	void ChangeData(int,void *data);

// item settings
	void LockItem(int);
	void UnlockItem(int);
	void MarkItem(int);
	void UnmarkItem(int);

// multi selection
	int FindNextMarked(int);
	int IsMarked(int);

// visible part
	void Top(int);
	int Top(void);
	void Selected(int);
	int Selected(void);

	int SelectedColumns(void);
};


struct column_spec
{
	unsigned int	flags;

	unsigned int	weight;	// percent
	unsigned int	width;	// multiples of line height *10 - ie. number of chars*10 with a fixed width font
	int         	adjust; // ADJUST_LEFT, ...

	// column hook
	void *hookclass;
	int (*hook)(struct hook_data*);
	void *userdata;
 		// int Hook(struct hook_data*, void*)
 		// returns space of painted object
 		// if negativ old output colors are restored

	char *title;
};


#define CSF_USEWEIGHT		0x00000001	// not allowed with CSF_USEWIDTH
#define CSF_USEWIDTH		0x00000002	// not allowed with CSF_USEWEIGHT
#define CSF_SELECTABLE		0x00000004
#define CSF_NOTSELECTABLE	0x00000008
#define CSF_HOOK			0x00000010
#define CSF_ADJUST			0x00000020
#define CSF_TITLE			0x00000040
#define CSF_USESHORTCUT		0x00000080


#define HOOKDATAVERSION	2

#define HD_SELECTED	0x00000001
#define HD_MARKED	0x00000002
#define HD_LOCKED	0x00000004

struct hook_data
{
	int			version;
	int			number;
	int			column;
	int			x;
	int			y;
	int			width;
	int			height;
	int			flags;
	gadget		*drawable;
	multilistview	*list;
	void		*itemdata;
	void		*userdata;
};

// -------------------------------------------------------------------
// some nice service functions for GUIs:
// -------------------------------------------------------------------

void lv_remove(class multilistview *,void *cl,void f(void *));
		// removes the selected or all marked lines and
		// calls for each f with the GetData() result
void lv_moveUp(class multilistview *);
void lv_moveDown(class multilistview *);
		// moves the selected or all marked lines one line
		// up or down - if this is possible
void lv_forMarked(multilistview *lv,void *cl,void f(void *));
		// calls f for the selected or all marked lines

#endif
