#ifndef INCL_XWINDOWS_H
#define INCL_XWINDOWS_H

// *-----------------------------------------------------------------------
// * Xclasses class header file
// * 
// * class name: Xwindows
// * author    : Jrgen Schmitz
// * version   : 1.0
// *-----------------------------------------------------------------------

#include <Xclasses/types.h>
#include <Xclasses/Xcolors.h>
#include <Xclasses/keyclass.h>

class Xwindows : public Xcolors
{
	friend class pXwindows;

	class pXwindows *p;	

public:

	Xwindows(void);
	virtual ~Xwindows(void);

	void Geometry(char *geo);
	void Geometry(int &argc,char *argv[]);
	int  Create(void);		
	int  Create(int x,int y,int width,int height);	
	void Background(unsigned long col);
	void Title(char *txt);
	void IconTitle(char *txt);
	void Class(char *rname,char *rclass); // 1st of rclass uppercase
	void OpenAsIcon(void);		
	void OpenAsWindow(void);
	void MinSize(int width,int height);
	void MaxSize(int width,int height);
	void ResizeInc(int width,int height);
	void Aspect(int minx,int miny,int maxx,int maxy);
	void BaseSize(int width,int height);		
	void OverrideRedirect(void);
	void Group(class Xwindows &);
	void Group(class Xwindows *);
	void Group(Window);
	void BorderWidth(int);
	void SaveUnder(void);
	void TransientFor(class Xwindows &);
	void TransientFor(class Xwindows *);
	void TransientFor(Window);
	void MCursor(int c);

	void Event(long mask);
	gadget *Keyactive(gadget *);
		
	void MakeFit(void);
	void Open(void);
	void OpenU(void);	// calls Update()
	void Close(void);
	void CloseU(void);	// calls Update()
	void Destroy(void);
	void Update(void);	// update output (XFlush())

	void UpdateHints(void);	// update Limits, Flags 
	void Raise(void);
	void Lower(void);

	void Resize(int width,int height);
	void Move(int x,int y);
	void Move(int x,int y,int width,int height); // Move&Resize

	void Size(int &width,int &height);
	void Position(int &x,int &y);
	void WMPosition(int &x,int &y);
	int IsCloseEvent(XEvent *event);
	int UserSized(void);

	class keyclass *Keyclass(void);

	Window window(void);

	void Beep(int vol,int duration=-1);
};

#endif
