#include <unistd.h>

#include <Xclasses/Xclasses.h>

XCprogram	myprg("buttons",
					XCP_Version,"3.2",
					XCP_Copyright,"may only copied with Xclasses for demonstration",
					XCP_Author,"Jrgen Schmitz",
					XCP_EMail,"schmitzj@fsai.fh-trier.de",
//					XCP_OwnText,"Dieses Programm dient nur zum Testen und Demonstrieren der Xclasses Gadgets. Ausser \"Ende\" klappt nicht viel!\n",
					XCP_OwnHTML,
		"Dieses Programm dient nur zum Testen und Demonstrieren der "
		"Xclasses Gadgets. Au&szlig;er \"Ende\" klappt nicht viel!"
		"<ul><li>Zeile 1<li>Zeile 2"
		"<li>Und die 3. Zeile wird ganz besonders lang.</ul>"
		,
					XCP_XC_logo,
					XCP_Done);

appwindow w;

group g1,ksg1,ksg2,mgkg3_1,mgkg3_2;
bordergroup kg2,mkg,mgkg1,mgkg2,mgkg3,ogp,mgkg4;
rubbergroup kg;
button ende;
selbutton b1,b2,b3,b4;
selknob k1;
checkbox k2;
mxknob mk1,mk2;
mxgadget mg1,mg2;
selbutton sb[5];
selknob sk[5];
selgadget *psb[6],*psk[6];
go_button gb1,gb2;
go_selbutton gs1,gs2;
gfx_arrow gobj1;
gfx_checkbox gobj2;
choice ch;
selbutton chlk;
card crd;
textbox tb1;
popup contpop;

menu mymenu;

bordergroup extragp;
button extrab1,extrab2;


char *btxt[]={"MX Knopf _1","MX Knopf 2","MX Knopf 3","MX Knopf 4",NULL};
//char *btxt2[]={"MX Knopf 1","MX Knopf 2","MX Knopf 3","MX Knopf 4",NULL};
//char *chtxts[]={"Option 1","Option 2","Option 3","Option 4",NULL};
char *chtxts[]={"Option 1","Option 2","Option 3","Option 4",
"Option 5","Option 6","Option 7","Option 8",
"Option 9","Option 10","Option 11","Option 12",
"Option 13","Option 14","Option 15","Option 16",
"Option 17","Option 18","Option 19","Option 20",
NULL};
char *mxmenu[]={"1","2","3",NULL};
char *mxmenuC[]={"A1","A2","A3",NULL};

#define GGFONT	FONT_GADGET
#define GPFONT 	FONT_GROUP

int main(int argc,char *argv[])
{
	int r,pende=0;

	w.InitSize(0,0,300,300);	
	if (!w.Init(argc,argv))
	{
		printf("Error:\nCan't open display %s.\n\n",w.DisplayName());
		exit(1);
	}

	w.Title("Buttons");
	w.IconTitle("Buttons Icon");
	
	g1.Vert();
	g1.Font(GPFONT);

	g1.Add(kg2);
	 kg2.Horiz();
	 kg2.Title("Knpfe");
	 kg2.Weight(200);
	 kg2.Add(kg);
	 kg.Horiz();
	 kg.Add(ksg1);
	  ksg1.Vert();
	  ksg1.Add(k1);
	   k1.Text("Knopf 1");
	   k1.Font(GGFONT);
	   k1.ID(10);
	   k1.HelpText("KNOB Objekt");
	  ksg1.Add(k2);
	   k2.Text("Kno_pf 2");
	   k2.Font(GGFONT);
	   k2.ID(11);
	   k2.HelpText("bewirkt Sperrung eines Buttons");
	  ksg1.Add(mkg);
	   mkg.Add(mk1);
	   mkg.Font(GPFONT);
	   mkg.Title("MX Knpfe");
	   mkg.ContextPopup(contpop);
 	    mk1.Font(GGFONT);
	    mk1.ID(2);
	    mk1.Items(btxt);
	    mk1.HelpText("Ein MX Gadget mit KNOB");
	  ksg1.Add(ch);
	   ch.Font(GGFONT);
	   ch.Items(chtxts);
	   ch.ID(17);
	  ksg1.Add(chlk);
	   chlk.Font(GGFONT);
	   chlk.Text("Sperren");
	   chlk.ID(16);

	 kg.Add(ksg2);
	  ksg2.Add(b1);
	   b1.Text("_Button 1");
	   b1.Font(GGFONT);
	   b1.ID(12);
	   b1.HelpText("Sperrt Knopf 1");
	  ksg2.Add(b2);
	   b2.Text("Button 2");
	   b2.Font(GGFONT);
	   b2.ID(13);
	   b2.HelpText("Sperrt Knopf 2");
	  ksg2.Add(b3);
	   b3.Text("Button 3");
	   b3.Font(GGFONT);
	   b3.ID(14);
	   b3.HelpText("Sperrt MX Knopf mit Gruppe");
	  ksg2.Add(b4);
	   b4.Text("Button 4");
	   b4.Font(GGFONT);
	   b4.ID(15);
	   b4.HelpText("Sperrt MX Knopf ohne Gruppe");

//	 kg.Add(mgkg);
	 kg.Add(crd);
	  mgkg1.Font(GPFONT);
	  mgkg1.Horiz();
	  mgkg1.Title("mxgadget 1");
	  mgkg1.Add(mg1);
	   sb[0].Text("B 1");
	   sb[0].Font(GGFONT);
	   sb[1].Text("B 2");
	   sb[1].Font(GGFONT);
	   sb[2].Text("B 3");
	   sb[2].Font(GGFONT);
	   sb[3].Text("B 4");
	   sb[3].Font(GGFONT);
	   sb[4].Text("B 5");
	   sb[4].Font(GGFONT);
	   MakeItems(sb,5,psb);
	   mg1.Items(psb);
	   mg1.ID(20);
	   mg1.ContextPopup(contpop);
	  mgkg2.Font(GPFONT);
	  mgkg2.Horiz();
	  mgkg2.Title("mxgadget 3");
	  mgkg2.Add(mk2);
	   mk2.Items(btxt);
	   mk2.ContextPopup(contpop);
	  mgkg3.Font(GPFONT);
	  mgkg3.Title("mxgadget 2");
	  mgkg3.Vert();
	   sk[0].Text("Knob 1");
	   sk[0].Font(GGFONT);
	   sk[1].Text("Knob 2");
	   sk[1].Font(GGFONT);
	   sk[2].Text("Knob 3");
	   sk[2].Font(GGFONT);
	   sk[3].Text("Knob 4");
	   sk[3].Font(GGFONT);
	   sk[4].Text("Knob 5");
	   sk[4].Font(GGFONT);
	   MakeItems(sk,5,psk);
	   mg2.ManageOnly();
	   mg2.Items(psk);
	  mgkg3.Add(mg2);
	  mgkg3.Add(mgkg3_1);
	   mgkg3_1.Horiz();
	   mgkg3_1.Add(sk[0]);
	   mgkg3_1.Add(sk[1]);
	   mgkg3_1.Add(sk[2]);
	  mgkg3.Add(mgkg3_2);
	   mgkg3_2.Horiz();
	   mgkg3_2.Add(sk[3]);
	   mgkg3_2.Add(sk[4]);
	  mgkg4.Add(tb1);
	  mgkg4.Title("textbox");
	   tb1.AlwaysShowLast();
	   tb1.AppendText("Hallo,\ndies ist ein Test der \"textbox\". Viel zu tun!\n");
	  
	 crd.Add("simple mx",mgkg1);
	 crd.Add("manageonly mx",mgkg3);
	 crd.Add("mx knob (normal)",mgkg2);
	 crd.Add("textbox",mgkg4);

	g1.Add(ogp);
	 ogp.Horiz();
	 ogp.Add(gb1);
	  gb1.Object(&gobj1);
	  gb1.UseLimit();
	  gb1.UseLocked();
	  gb1.Font(GGFONT);
	  gb1.NoBorder();
	 ogp.Add(gb2);
	  gb2.Object(&gobj1);
	  gb2.NoLimit();
	  gb2.NotUseLocked();
	  gb2.Font(GGFONT);
	  gb2.SendTicks();
	  gb2.ID(100);
	 ogp.Add(gs1);
	  gs1.Object(&gobj2);
	  gs1.UseLimit();
	  gs1.UseLocked();
	  gs1.Font(GGFONT);
	  gs1.NoBorder();
	 ogp.Add(gs2);
	  gs2.Object(&gobj2);
	  gs2.NoLimit();
	  gs2.NotUseLocked();
	  gs2.Font(GGFONT);
	  gs2.ContextPopup(contpop);
	g1.Add(ende);
	 ende.Weight(10);
	 ende.Text("Programm beenden");
	 ende.Font(GGFONT);
	 ende.ID(1);
	 ende.HelpText("Beendet\ndas Programm.");
	 ende.ContextPopup(contpop);

	contpop.AddHeadline("Context popup");
	contpop.Add("Quit",NULL,1);
	contpop.ID(1);

	gobj1.Direction(ARROW_DOWN);

	mymenu.AddMenu("Datei");
	mymenu.Add("Test 1","a",1);
	mymenu.Add("Test 2","A",2);
	mymenu.AddRuler();
	mymenu.Add("Ende","ESC",3);
	mymenu.AddMenu("Fenster");
	mymenu.Add("Fenster 1","1",4);
	mymenu.Add("Fenster 2","2",5);
	mymenu.AddMenu("Test");
	mymenu.AddSel("Test 1",6);
	mymenu.AddSub("Subtest 1");
	mymenu.Add("Test 1",7);
	mymenu.AddSel("Sel 1",8);
	mymenu.EndSub();
	mymenu.Add("Test 2",9);
	mymenu.AddSub("Subtest 2");
	mymenu.Add("Test 1",10);
	mymenu.AddSel("Sel 1",11);
	mymenu.EndSub();
	mymenu.AddSub("Subtest 12");
	mymenu.Add("Test 1",13);
	mymenu.AddRuler();
	mymenu.AddHeadline("MX");
	mymenu.AddMX(mxmenu,mxmenuC,14);
	mymenu.EndSub();

	mymenu.LockItem(3,9);
	mymenu.LockItem(3,8);
	mymenu.LockHeadOf(3,10);

	extragp.Horiz();
	extragp.Add(extrab1);
	 extrab1.Text("Button 1");
	extragp.Add(extrab2);
	 extrab2.Text("Button 2");

	w.SetGroup(g1);
	w.SetExtraGroup(extragp);
	w.SetMenu(mymenu);
	w.Create();

	do
	{
		r=w.NextEvent();
		if (r==EV_WINDOWCLOSE)
		{
			pende=1;
		}
		else if (r==EV_GADGET)
		{
			switch (w.ID())
			{
				case 1:
					pende=1;
					break;
				case 10:
					if (k1.State()==PRESSED)
					{
						b1.Lock();
					}
					else
					{
						b1.Unlock();
					}
					break;
				case 11:
					if (k2.State()==PRESSED)
					{
						b2.Lock();
						w.ShowExtra();
					}
					else
					{
						b2.Unlock();
						w.HideExtra();
					}
					break;
				case 12:
					if (b1.State()==PRESSED)
					{
						k1.Lock();
					}
					else
					{
						k1.Unlock();
					}
					break;
				case 13:
					if (b2.State()==PRESSED)
					{
						k2.Lock();
					}
					else
					{
						k2.Unlock();
					}
					break;
				case 14:
					if (b3.State()==PRESSED)
					{
						mkg.Lock();
						b4.State(PRESSED);
					}
					else
					{
						mkg.Unlock();
						b4.State(RELEASED);
					}
					break;
				case 15:
					if (b4.State()==PRESSED)
					{
						mk1.Lock();
					}
					else
					{
						mk1.Unlock();
					}
					break;
				case 16:
					if (chlk.State()==PRESSED)
					{
						ch.Lock();
						crd.Lock();
					}
					else
					{
						crd.Unlock();
						ch.Unlock();
					}
					break;
				case 17:
					{
						char t[40];
						sprintf(t,"Option %d\n",ch.Selected()+1);
						tb1.AppendText(t);
					}
					break;
				case 100:
					{
						int os=mg2.Selected();
						mg2.Selected(mg2.Selected()+1);
						if (os==mg2.Selected()) mg2.Selected(0);
					}
					break;
				case 20:
					if (mg1.Selected()==0)
					{
						gb1.Lock();
						gs1.Lock();
					}
					if (mg1.Selected()==1)
					{
						gb1.Unlock();
						gs1.Unlock();
					}
					if (mg1.Selected()==2)
					{
						gb2.Lock();
						gs2.Lock();
					}
					if (mg1.Selected()==3)
					{
						gb2.Unlock();
						gs2.Unlock();
					}
					break;
			}
		}
	}
	while (!pende);

	w.Close();
}
