/* $Id: Tab.C,v 1.6 1999/11/06 05:51:01 glgay Exp $ */
/*
 Copyright (C) 1996 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/Tab.h>
/* TabClass member functions */
void
TabClass::autoSpace(int size)
{
   /* auto space buttons */
   int border = width();
   if(border < size) {
      int offset = (size-border)%2;
      border = (size - border)/2;
      XtVaSetValues(widget(),XmNmarginLeft,border,
         XmNmarginRight, ((Dimension) border+offset), NULL);
   } 
}

Widget
TabClass::createWidget(_XtString name,
                       Widget w_parent,
                       ArgList arglist,
                       Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreateTab(w_parent, name, arglist, cnt);
}

/* constructors */

Tab::Tab(Widget w_parent, char *str, _XtString name)
{
   Widget wid = createWidget(name, w_parent);
   widget(wid);
   labelString(str);

   alignment(XmALIGNMENT_CENTER);

   manage();
}

Tab::Tab(Widget w_parent, ArgList arglist, Cardinal cnt, 
                       _XtString name)
{
   Widget wid = createWidget(name, w_parent, arglist, cnt);
   
   widget(wid);
   manage();
}

Tab::Tab(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(wid);
   widget(wid);
   manage();
}

Tab::Tab(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name, w_parent);
   
   widget(wid);
   manage();
}
