/* $Id: List.C,v 1.10 2000/01/30 13:18:33 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/List.h>

/* ListClass Members */

/* extras */
void 
ListClass::add(const char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XmListAddItem(widget(),xmstr,0);
   XmStringFree(xmstr);
}

void
ListClass::add(const char **l, int c)
{
   int i;
   XmString *xmstr = new XmString [c];
   for(i=0; i<c; i++)
   {
      xmstr[i] = cvtStringToXmString(l[i]);
   }
   XmListAddItems(widget(), xmstr, c, 0);
   for(i = 0; i<c; i++)
   {
      XmStringFree(xmstr[i]);
   } 
   delete [] xmstr;
}

void
ListClass::deselect(const char *str)
{
   XmString xmstr = cvtStringToXmString((char *)str);
   XmListDeselectItem(widget(), xmstr);
   XmStringFree(xmstr);
}

void
ListClass::del(const char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XmListDeleteItem(widget(), xmstr);
   XmStringFree(xmstr);
}

void
ListClass::del(const char **slist, int n)
{
   int i;
   XmString *xmstr = new XmString [n];
   for(i=0; i<n; i++)
   {
      xmstr[i] = cvtStringToXmString(slist[i]);
   }
   XmListDeleteItems(widget(), xmstr, n);
   for(i = 0; i<n; i++)
   {
      XmStringFree(xmstr[i]);
   } 
   delete [] xmstr;
}

int
ListClass::exists(const char *str)
{
   XmString xmstr = cvtStringToXmString((char *)str);
   int ret = (int) XmListItemExists(widget(),xmstr);
   XmStringFree(xmstr);
   return ret;
}

void
ListClass::insert(const char *str, int p)
{
   XmString xmstr = cvtStringToXmString(str);
   XmListAddItem(widget(),xmstr,p);
   XmStringFree(xmstr);
}

void
ListClass::insert(const char **l, int c, int p)
{
   int i;
   XmString *xmstr = new XmString [c];
   for(i=0; i<c; i++)
   {
      xmstr[i] = cvtStringToXmString(l[i]);
   }
   XmListAddItems(widget(), xmstr, c, p);
   for(i = 0; i<c; i++)
   {
      XmStringFree(xmstr[i]);
   } 
   delete [] xmstr;
}

int
ListClass::item(const char *str)
{
   XmString xmstr = cvtStringToXmString((char *) str);
   int ret = XmListItemPos(widget(),xmstr);
   XmStringFree(xmstr);
   return ret;
}
int
ListClass::match(const char *str, int * &p, int &c)
{
   int res = False;
   XmString xmstr = cvtStringToXmString(str);
   res = XmListGetMatchPos(widget(), xmstr, &p, &c);
   XmStringFree(xmstr);
   return res;
}

void
ListClass::replace(const char **l, int c, int p)
{
   int i;
   XmString *xmstr = new XmString [c];
   for(i=0; i<c; i++)
   {
      xmstr[i] = cvtStringToXmString(l[i]);
   }
   XmListReplaceItemsPos(widget(), xmstr, c, p);
   for(i = 0; i<c; i++)
   {
      XmStringFree(xmstr[i]);
   } 
   delete [] xmstr;
}

void
ListClass::replace(const char **o, int c, const char **n)
{
   int i;
   XmString *xmold = new XmString [c];
   XmString *xmnew = new XmString [c];
   for(i=0; i<c; i++)
   {
      xmold[i] = cvtStringToXmString(o[i]);
      xmnew[i] = cvtStringToXmString(n[i]);
   }
   XmListReplaceItems(widget(), xmold, c, xmnew);
   for(i = 0; i<c; i++)
   {
      XmStringFree(xmold[i]);
      XmStringFree(xmnew[i]);
   } 
   delete [] xmold;
   delete [] xmnew;
}

void
ListClass::select(const char *str, int notify)
{
   XmString xmstr = cvtStringToXmString((char *)str);
   XmListSelectItem(widget(), xmstr, notify);
   XmStringFree(xmstr);
}

void
ListClass::select(int p, int notify)
{
   XmListSelectPos(widget(),p,notify);
}

void
ListClass::set(const char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XmListSetItem(widget(), xmstr);
   XmStringFree(xmstr);
}

void
ListClass::setBottom(const char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XmListSetBottomItem(widget(), xmstr);
   XmStringFree(xmstr);
}

void ListClass::selectedItems(const char **items)
{
   int       numItems;
   int       x;
   XmString *xmItems;

   if (items == NULL) return;

   XmListDeselectAllItems(widget());

   // Count the number of items passed;

   for (numItems = 0; items[numItems] != NULL; ++numItems) ;

   if (numItems == 0) return;

   xmItems = new XmString[numItems];

   for (x = 0; x < numItems; ++x) xmItems[x] = cvtStringToXmString(items[x]);

   XtVaSetValues(widget(),
		 XmNselectedItems,
		 xmItems,
		 NULL);

   for (x = 0; x < numItems; ++x) XmStringFree(xmItems[x]);

   delete [] xmItems;

}

char **ListClass::selectedItems() const
{
    int             numItems;
    int             x;
    char          **myItems;
    XmStringTable   xmItems;

    numItems = selectedItemCount() + 1;

    XtVaGetValues(widget(),
		  XmNselectedItems,
		  &xmItems,
		  NULL);

    myItems = new char *[numItems];

    if (myItems == NULL) return NULL;

    for (x = 0; x < numItems - 1; ++x) {
      myItems[x] = cvtXmStringToString(xmItems[x]);
      if (myItems[x] == NULL) break;
    }

    myItems[numItems - 1] = NULL;

    return myItems;
}

void ListClass::freeSelectedItems(char **items) const
{
    int x;

    for (x = 0; items[x] != NULL; ++x) {
      XtFree(items[x]);
    }

    delete [] items;
}

