/* $Id: CDEComboBox.C,v 1.9 1999/11/06 05:51:00 glgay Exp $ */
/*
 Copyright (C) 1996 Peter Williams

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#include <Xarm/ComboBox.h>

/*
* The ComboBox only exists in versions of Motif >= 2.
* However, you could write one yourself and remove this restriction.
*/
#ifdef XARM_HAS_CDE

/* convenience routines */
Widget
ComboBoxClass::list() const
{
   return XtNameToWidget(widget(), "*List");
}

void ComboBoxClass::add(const char *str, int pos, Boolean unique)
{
   XmString xmstr = cvtStringToXmString(str);
   DtComboBoxAddItem(widget(), xmstr, pos, unique);
   XmStringFree(xmstr);
}

void ComboBoxClass::setItem(const char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   DtComboBoxSetItem(widget(), xmstr);
   XmStringFree(xmstr);
}

void ComboBoxClass::del(int pos)
{
   DtComboBoxDeletePos(widget(), pos);
}

void ComboBoxClass::clear()
{
    // This is a much faster clear function!
    // It works in Solaris CDE and in Linux/Xig CDE
    // Let me know if it causes anyone any problems

    XtVaSetValues(widget(), XmNitems, NULL, XmNitemCount, 0, NULL);
}
   
/* extras */
/* This is how you wrap existing widgets. */
class WrapList : public ListClass {
 public:
   WrapList(Widget w) { widget(w); }  
};

ListClass *
ComboBoxClass::listObject() const
{
   ListClass *foo; 

   foo = (ListClass *) WidgetToWObject(list());   
   if (foo == NULL)
   {  /* then no wrap yet so wrap it */
      foo = new WrapList(list());
   }
   return foo;
}

#endif

