/* $Id: Base.C,v 1.6 1999/11/06 05:51:00 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


/* Include(s): */
#include <Xarm/Base.h>
#include <Xarm/ImageCache.h>

/* Conversion function */
WObject
WidgetToWObject(Widget w)
{
   if(XtIsWidget(w))
   {
      if(XtHasCallbacks(w, XmNdestroyCallback) == XtCallbackHasSome)
      {
         XtCallbackList clist;
         XtVaGetValues(w, XmNdestroyCallback, &clist, NULL); 
         for(;clist->callback;clist++)
         {
            if(clist->callback == WObjectClass::destructor)
            {  
               return (WObject) clist->closure;
            }
         }
      }
   }
   return NULL;
}

/* =============================================================== */
/* WObjectClass members */

void 
WObjectClass::destructor(Widget, XtPointer killme, XtPointer)
{
   delete ((WObjectClass *)killme);
}

WObjectClass::operator Widget() const
{ 
   return widget(); 
}

WObjectClass::operator Display*() const
{ 
   return display();
}

void 
WObjectClass::deleteOnClose(int option)
{
   if(option == FALSE)
   {
      if(isDelete == TRUE && wid) 
      {
         removeDestructor(); /* remove previous setting */
      }
      isDelete = FALSE;
   }
   else if(option == TRUE)
   {
      if(isDelete == FALSE && wid) 
      {
         addDestructor(); /* add setting */
      }
      isDelete = TRUE;
   }
   /* else invalid setting */
}

void
WObjectClass::destroyCallback(XtCallbackProc fp, XtPointer data)
{
   addCallback(XmNdestroyCallback, fp, data);
}

Widget
WObjectClass::createWidget(_XtString name,
                           Widget w_parent, 
                           ArgList arglist, 
                           Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XtCreateWidget(name, classPointer(), w_parent, arglist, cnt);
}

XtAppContext
WObjectClass::appContext() const
{
   return XtWidgetToApplicationContext(widget()); 
}

Pixmap
WObjectClass::getPixmap(const char *fname) const
{
   return XarmGetPixmap(widget(),fname);
}

Pixmap
WObjectClass::getPixmapFromData(const char **pdata) const
{
   return XarmGetPixmapFromData(widget(),pdata);
}

void
WObjectClass::widget(const Widget w) 
{
   if(wid) deleteOnClose(FALSE);
   wid = w;
   deleteOnClose(); /* set to whatever is the desired default */
}
 
WObjectClass::~WObjectClass() 
{
   if( widget() && (widget()->core.being_destroyed == FALSE) )
   {
      removeDestructor(); XtDestroyWidget(*this);
   }
}  

void 
WObjectClass::addDestructor() 
{
   addCallback(XmNdestroyCallback,
               (XtCallbackProc) destructor, 
               (XtPointer) this);
}

void 
WObjectClass::removeDestructor() 
{
   removeCallback(XmNdestroyCallback, 
                  (XtCallbackProc) destructor,
                  (XtPointer) this);
}

void
WObjectClass::addCallback(_XtString type,
                          XtCallbackProc fp, 
                          XtPointer closure)
{
   XtAddCallback(widget(),type,fp,closure);
}

void
WObjectClass::addCallback(Widget w, 
                          _XtString type, 
                          p_msg fp, 
                          XtPointer closure)
{
   CObject::addCallback(w,type,fp,closure);
}

void
WObjectClass::removeCallback(_XtString type, 
                             XtCallbackProc fp, 
                             XtPointer closure)
{
   XtRemoveCallback(widget(),type,fp,closure);
}

void
WObjectClass::removeCallback(Widget w, 
                          _XtString type, 
                          p_msg fp, 
                          XtPointer closure)
{
   CObject::removeCallback(w,type,fp,closure);
}

void
WObjectClass::removeAllCallbacks(_XtString type)
{
   CObject::removeAllCallbacks(widget(),type);
}

void
WObjectClass::removeAllCallbacks(Widget w,_XtString type)
{
   CObject::removeAllCallbacks(w,type);
}

Atom 
WObjectClass::addWMProtocol(char *atom_name, Bool add_if_exists)
{
   Atom wm_atom, property;

   wm_atom = XInternAtom(display(),atom_name, add_if_exists);
   property = XM_WM_PROTOCOL_ATOM(widget());

   addProtocol(property,wm_atom);
   return wm_atom;
}

void
WObjectClass::addProtocol(Atom property, Atom atom_to_add)
{
   XmAddProtocols(widget(),property, &atom_to_add,1);
}

/* */
