/* $Id: TextF.h,v 1.5 1999/11/06 05:50:59 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_textf_h)
#define xarm_textf_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Primitive.h>

class TextFieldClass : public PrimitiveClass {
 protected:
   TextFieldClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer() { return xmTextFieldWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmTextField"; }
 public:
   /* callbacks */
   void activateCallback(XtCallbackProc fp, XtPointer data = NULL)
         { XARM_SET_CALLBACK(XmNactivateCallback); }
   void focusCallback(XtCallbackProc fp, XtPointer data = NULL)
         { XARM_SET_CALLBACK(XmNfocusCallback); }
   void gainPrimaryCallback(XtCallbackProc fp, XtPointer data = NULL)
         { XARM_SET_CALLBACK(XmNgainPrimaryCallback); }
   void losePrimaryCallback(XtCallbackProc fp, XtPointer data = NULL)
         { XARM_SET_CALLBACK(XmNlosePrimaryCallback); }
   void losingFocusCallback(XtCallbackProc fp, XtPointer data = NULL)
         { XARM_SET_CALLBACK(XmNlosingFocusCallback); }
   void modifyVerifyCallback(XtCallbackProc fp, XtPointer data = NULL)
         { XARM_SET_CALLBACK(XmNmodifyVerifyCallback); }
   void modifyVerifyCallbackWcs(XtCallbackProc fp, XtPointer data = NULL)
         { XARM_SET_CALLBACK(XmNmodifyVerifyCallbackWcs); }
   void motionVerifyCallback(XtCallbackProc fp, XtPointer data = NULL)
         { XARM_SET_CALLBACK(XmNmotionVerifyCallback); }
   void valueChangedCallback(XtCallbackProc fp, XtPointer data = NULL)
         { XARM_SET_CALLBACK(XmNvalueChangedCallback); }

   /* convenience functions */
   void clearSelection(Time time)                  { XmTextFieldClearSelection(widget(), time); }
   Boolean copy(Time time)                         { return XmTextFieldCopy(widget(),time); }
   Boolean cut(Time time)                          { return XmTextFieldCut(widget(),time); }
   int getBaseline() const                         { return XmTextFieldGetBaseline(widget()); }
   XmTextPosition getCursorPosition() const        { return XmTextFieldGetCursorPosition(widget()); }
   Boolean getEditable() const                     { return XmTextFieldGetEditable(widget()); }
   XmTextPosition getInsertionPosition() const     { return XmTextFieldGetInsertionPosition(widget()); }
   XmTextPosition getLastPosition() const          { return XmTextFieldGetLastPosition(widget()); }
   int getMaxLength() const                        { return XmTextFieldGetMaxLength(widget()); }
   char *getSelection() const                      { return XmTextFieldGetSelection(widget()); }
   Boolean getSelectionPosition(XmTextPosition *left, XmTextPosition *right)
         { return XmTextFieldGetSelectionPosition(widget(), left, right); }
   wchar_t *getSelectionWcs() const                { return XmTextFieldGetSelectionWcs(widget()); }
   char *getString() const                         { return XmTextFieldGetString(widget()); }
   wchar_t *getStringWcs() const                   { return XmTextFieldGetStringWcs(widget()); }
   int getSubstring(XmTextPosition start, int no_chars, int buf_sz, char *buf)
         { return XmTextFieldGetSubstring(widget(), start, no_chars, buf_sz, buf); }
   int getSubstringWcs(XmTextPosition start, int no_chars, int buf_sz, wchar_t *buf)
         { return XmTextFieldGetSubstringWcs(widget(), start, no_chars, buf_sz, buf); }
   void insert(XmTextPosition pos, const char *str);
   void insertWcs(XmTextPosition pos, const wchar_t *str);
   Boolean paste() const                           { return XmTextFieldPaste(widget()); }
   Boolean posToXY(XmTextPosition pos, Position *xpos, Position *ypos)
         { return XmTextFieldPosToXY(widget(),pos,xpos,ypos); }
   Boolean remove()                                { return XmTextFieldRemove(widget()); }
   void replace(XmTextPosition from, XmTextPosition to, const char *val);
   void replaceWcs(XmTextPosition from, XmTextPosition to, const wchar_t *val);
   void setAddMode(Boolean state)                  { XmTextFieldSetAddMode(widget(), state); }
   void setCursorPosition(XmTextPosition pos)      { XmTextFieldSetCursorPosition(widget(), pos); }
   void setEditable(Boolean edit)                  { XmTextFieldSetEditable(widget(), edit); }
   void setHighlight(XmTextPosition left, XmTextPosition right, XmHighlightMode mode)
         { XmTextFieldSetHighlight(widget(), left, right, mode); }
   void setInsertionPosition(XmTextPosition pos)   { XmTextFieldSetInsertionPosition(widget(), pos); }
   void setMaxLength(int max)                      { XmTextFieldSetMaxLength(widget(), max); }
   void setSelection(XmTextPosition first, XmTextPosition last, Time t)
         { XmTextFieldSetSelection(widget(), first, last, t); }
   void setString(const char *str);
   void setStringWcs(const wchar_t *str);
   void showPosition(XmTextPosition pos)           { XmTextFieldShowPosition(widget(), pos); }
   XmTextPosition xyToPos(Position xpos, Position ypos) const
         { return XmTextFieldXYToPos(widget(), xpos, ypos); }
   
   /* resources */
   void blinkRate(int val)                         { XARM_SET_VALUE(XmNblinkRate); }
   int blinkRate() const                           { XARM_GET_VALUE(int, XmNblinkRate); }
   void columns(short val)                         { XARM_SET_VALUE(XmNcolumns); }
   short columns() const                           { XARM_GET_VALUE(short, XmNcolumns); }
   void cursorPosition(const XmTextPosition val)   { XARM_SET_VALUE(XmNcursorPosition); }
   XmTextPosition cursorPosition() const           { XARM_GET_VALUE(XmTextPosition,XmNcursorPosition); }
   void cursorPositionVisible(Boolean val)         { XARM_SET_VALUE(XmNcursorPositionVisible); }
   Boolean cursorPositionVisible() const           { XARM_GET_VALUE(Boolean, XmNcursorPositionVisible); }
   void editable(Boolean val)                      { XARM_SET_VALUE(XmNeditable); }
   Boolean editable() const                        { XARM_GET_VALUE(Boolean, XmNeditable); }
   void fontList(const XmFontList val)             { XARM_SET_VALUE(XmNfontList); }
   XmFontList fontList() const                     { XARM_GET_VALUE(XmFontList, XmNfontList); }
   void marginHeight(Dimension val)                { XARM_SET_VALUE(XmNmarginHeight); }
   Dimension marginHeight() const                  { XARM_GET_VALUE(Dimension, XmNmarginHeight); }
   void marginWidth(Dimension val)                 { XARM_SET_VALUE(XmNmarginWidth); }
   Dimension marginWidth() const                   { XARM_GET_VALUE(Dimension, XmNmarginWidth); }
   void maxLength(int val)                         { XARM_SET_VALUE(XmNmaxLength); }
   int maxLength() const                           { XARM_GET_VALUE(int, XmNmaxLength); }
   void pendingDelete(Boolean val)                 { XARM_SET_VALUE(XmNpendingDelete); }
   Boolean pendingDelete() const                   { XARM_GET_VALUE(Boolean, XmNpendingDelete); }
   void resizeWidth(Boolean val)                   { XARM_SET_VALUE(XmNresizeWidth); }
   Boolean resizeWidth() const                     { XARM_GET_VALUE(Boolean, XmNresizeWidth); }
   void selectionArray(const XmTextScanType * val) { XARM_SET_VALUE(XmNselectionArray); }
   XmTextScanType *selectionArray() const          { XARM_GET_VALUE(XmTextScanType *, XmNselectionArray); }
   void selectionArrayCount(int val)               { XARM_SET_VALUE(XmNselectionArrayCount); }
   int selectionArrayCount() const                 { XARM_GET_VALUE(int, XmNselectionArrayCount); }
   void selectThreshold(int val)                   { XARM_SET_VALUE(XmNselectThreshold); }
   int selectThreshold() const                     { XARM_GET_VALUE(int, XmNselectThreshold); }
   void value(const _XtString val)                 { XARM_SET_VALUE(XmNvalue); }
   _XtString value() const                         { XARM_GET_VALUE(_XtString, XmNvalue); }
   void valueWcs(const wchar_t *val)               { XARM_SET_VALUE(XmNvalueWcs); }
   wchar_t *valueWcs() const                       { XARM_GET_VALUE(wchar_t *, XmNvalueWcs); }
   void verifyBell(Boolean val)                    { XARM_SET_VALUE(XmNverifyBell); }
   Boolean verifyBell() const                      { XARM_GET_VALUE(Boolean, XmNverifyBell); }
};

typedef XarmRawWidget<TextFieldClass, true> TextField;

#endif
