/* $Id: Page.h,v 1.5 1999/11/06 05:50:58 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_page_h)
#define xarm_page_h

/*
 * Warning:  These classes diverge from the Motif 1.2 standard GUI and 
 * use widgets written by the author.
 */

/* ======================================================================= */
/* Include(s): */
#include <Xmext/Page.h>
#include <Xarm/BulletinB.h>

class PropertyPageClass : public BulletinBoardClass {
 protected:
   PropertyPageClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer() { return xmPropertyPageWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmPropertyPage"; }

 public:

   /* Callbacks */
   /* activate callbacks for the following default buttons */
   void cancelCallback(XtCallbackProc fp, XtPointer data = NULL)     { XARM_SET_CALLBACK(XmNcancelCallback); }
   void okCallback(XtCallbackProc fp, XtPointer data = NULL)         { XARM_SET_CALLBACK(XmNokCallback); }
   void applyCallback(XtCallbackProc fp, XtPointer data = NULL)      { XARM_SET_CALLBACK(XmNapplyCallback); }

   /* Called when the current page is no longer active. */
   void killActiveCallback(XtCallbackProc fp, XtPointer data = NULL) { XARM_SET_CALLBACK(XmNkillActiveCallback); }
   /* Called when the page is made the active page. */
   void setActiveCallback(XtCallbackProc fp, XtPointer data = NULL)  { XARM_SET_CALLBACK(XmNsetActiveCallback); }

   /* extras */
   void setModified(Boolean b = TRUE); /* enable or disable apply button */
   void cancelLabelString(const char *s);  /* changes text of cancel button */
   
};

typedef XarmFuncWidget<PropertyPageClass, XmCreatePropertyPage, false> PropertyPage;

#endif
