/* $Id: MainW.h,v 1.5 1999/11/06 05:50:58 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_mainw_h)
#define xarm_mainw_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/ScrolledW.h>

class MainWindowClass : public ScrolledWindowClass {
 protected:
   MainWindowClass() {}
   virtual WidgetClass classPointer() { return xmMainWindowWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmMainWindow"; }
 public:
   /* convenience routines */
   Widget separator1() const;
   Widget separator2() const;
   Widget separator3() const;
   void setArea(Widget menu,Widget command,
		Widget hscroll, Widget vscroll,
		Widget work);

   /* resources */
   void commandWindow(Widget val)               { XARM_SET_VALUE(XmNcommandWindow); }
   Widget commandWindow() const                 { XARM_GET_VALUE(Widget, XmNcommandWindow); }
   unsigned char commandWindowLocation() const  { XARM_GET_VALUE(unsigned char, XmNcommandWindowLocation); }
   void mainWindowMarginHeight(Dimension val)   { XARM_SET_VALUE(XmNmainWindowMarginHeight); }
   Dimension mainWindowMarginHeight() const     { XARM_GET_VALUE(Dimension, XmNmainWindowMarginHeight); }
   void mainWindowMarginWidth(Dimension val)    { XARM_SET_VALUE(XmNmainWindowMarginWidth); }
   Dimension mainWindowMarginWidth() const      { XARM_GET_VALUE(Dimension, XmNmainWindowMarginWidth); }
   void menuBar(Widget val)                     { XARM_SET_VALUE(XmNmenuBar); }
   Widget menuBar() const                       { XARM_GET_VALUE(Widget, XmNmenuBar); }
   void messageWindow(Widget val)               { XARM_SET_VALUE(XmNmessageWindow); }
   Widget messageWindow() const                 { XARM_GET_VALUE(Widget, XmNmessageWindow); }
   void showSeparator(Boolean val)              { XARM_SET_VALUE(XmNshowSeparator); }
   Boolean showSeparator() const                { XARM_GET_VALUE(Boolean, XmNshowSeparator); }
};

//----------------------------------------//
// MainWindow isn't a typedef because he  //
// has non-standard constructors.         //
//----------------------------------------//

class MainWindow : public MainWindowClass {
 public:
   MainWindow(Widget w_parent, 
              unsigned char scroll_policy,
              Boolean show_separator = FALSE,
              _XtString name = NULL);
   MainWindow(Widget w_parent, 
              Dimension width, 
              Dimension height,
              unsigned char scroll_policy = XmAPPLICATION_DEFINED,
              Boolean show_separator = FALSE,
              _XtString name = NULL);
   MainWindow(Widget w_parent, 
              ArgList arglist = NULL, 
              Cardinal cnt = 0,
              _XtString name = NULL);
   MainWindow(_XtString name, Widget w_parent); 
   MainWindow(Widget w_parent, XarmArg &args, _XtString name);
};
   
#endif
