/* $Id: Gauge.h,v 1.4 1999/11/06 05:50:58 glgay Exp $ */
/*
 Copyright (C) 1999 Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_gauge_h)
#define xarm_gauge_h

/*
 * Warning:  These classes diverge from the Motif 1.2 standard GUI.
 */

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Primitive.h>
#include <Xmext/Gauge.h>

class GaugeClass : public PrimitiveClass {
 protected:
   GaugeClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer()                    { return xmGaugeWidgetClass; }
   virtual _XtString className()                         { return (_XtString) "XmGauge"; }

 public:
   /* resources */
   void          gaugeMargin(int val)                    { XARM_SET_VALUE(XmNgaugeMargin); }
   int           gaugeMargin() const                     { XARM_GET_VALUE(int, XmNgaugeMargin); }
   void          fill(Boolean val)                       { XARM_SET_VALUE(XmNfill); }
   Boolean       fill() const                            { XARM_GET_VALUE(Boolean, XmNfill); }
   void          maximum(int val)                        { XARM_SET_VALUE(XmNmaximum); }
   int           maximum() const                         { XARM_GET_VALUE(int, XmNmaximum); }
   void          minimum(int val)                        { XARM_SET_VALUE(XmNminimum); }
   int           minimum() const                         { XARM_GET_VALUE(int, XmNminimum); }
   void          orientation(unsigned char val)          { XARM_SET_VALUE(XmNorientation); }
   unsigned char orientation() const                     { XARM_GET_VALUE(unsigned char, XmNorientation); }
   void          processingDirection(unsigned char val)  { XARM_SET_VALUE(XmNprocessingDirection); }
   unsigned char processingDirection() const             { XARM_GET_VALUE(unsigned char, XmNprocessingDirection); }
   void          showMinMax(Boolean val)                 { XARM_SET_VALUE(XmNshowMinMax); }
   Boolean       showMinMax() const                      { XARM_GET_VALUE(Boolean, XmNshowMinMax); }
   void          showPercentage(Boolean val)             { XARM_SET_VALUE(XmNshowPercentage); }
   Boolean       showPercentage() const                  { XARM_GET_VALUE(Boolean, XmNshowPercentage); }
   void          showValue(Boolean val)                  { XARM_SET_VALUE(XmNshowValue); }
   Boolean       showValue() const                       { XARM_GET_VALUE(Boolean, XmNshowValue); }
#if 1 
   // Default mechanism needs fixing
   void          sliderColor(Pixel val)                  { XARM_SET_VALUE(XmNsliderColor); }
   void          sliderColor(const char *val)            { XARM_SET_TYPED(XmNsliderColor); }
   Pixel         sliderColor() const                     { XARM_GET_VALUE(Pixel, XmNsliderColor); }
#endif
   void          sliderShadowThickness(int val)          { XARM_SET_VALUE(XmNsliderShadowThickness); }
   int           sliderShadowThickness() const           { XARM_GET_VALUE(int, XmNsliderShadowThickness); }
   void          sliderSize(int val)                     { XARM_SET_VALUE(XmNsliderSize); }
   int           sliderSize() const                      { XARM_GET_VALUE(int, XmNsliderSize); }
   void          tickIncrement(int val)                  { XARM_SET_VALUE(XmNtickIncrement); }
   int           tickIncrement() const                   { XARM_GET_VALUE(int, XmNtickIncrement); }
   void          troughColor(Pixel val)                  { XARM_SET_VALUE(XmNtroughColor); }
   void          troughColor(const char *val)            { XARM_SET_TYPED(XmNtroughColor); }
   Pixel         troughColor() const                     { XARM_GET_VALUE(Pixel, XmNtroughColor); }
   void          troughShadowThickness(int val)          { XARM_SET_VALUE(XmNtroughShadowThickness); }
   int           troughShadowThickness() const           { XARM_GET_VALUE(int, XmNtroughShadowThickness); }
   void          value(int val)                          { XARM_SET_VALUE(XmNvalue); }
   int           value() const                           { XARM_GET_VALUE(int, XmNvalue); }
};

typedef XarmFuncWidget<GaugeClass, XmCreateGauge, true> Gauge;

#endif
