/* $Id: Form.h,v 1.5 1999/11/06 05:50:58 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_form_h)
#define xarm_form_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/BulletinB.h>

class FormClass : public BulletinBoardClass {
 protected:
   FormClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer()     { return xmFormWidgetClass; }
   virtual _XtString className()          { return (_XtString) "XmForm"; } 
 public:
   /* resources */
   void fractionBase(int val)             { XARM_SET_VALUE(XmNfractionBase); }
   int fractionBase() const               { XARM_GET_VALUE(int, XmNfractionBase); }
   void horizontalSpacing(Dimension val)  { XARM_SET_VALUE(XmNhorizontalSpacing); }
   Dimension horizontalSpacing() const    { XARM_GET_VALUE(Dimension, XmNhorizontalSpacing); }
   void rubberPositioning(Boolean val)    { XARM_SET_VALUE(XmNrubberPositioning); }
   Boolean rubberPositioning() const      { XARM_GET_VALUE(Boolean, XmNrubberPositioning); }
   void verticalSpacing(Dimension val)    { XARM_SET_VALUE(XmNverticalSpacing); }
   Dimension verticalSpacing() const      { XARM_GET_VALUE(Dimension, XmNverticalSpacing); }
};

typedef XarmRawWidget<FormClass, false>                      Form;
typedef XarmFuncWidget<FormClass, XmCreateFormDialog, false> FormDialog;

#endif
