/* $Id: DrawnB.h,v 1.5 1999/11/06 05:50:58 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_drawnb_h)
#define xarm_drawnb_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Label.h>

class DrawnButtonClass : public LabelClass {
 protected:
   DrawnButtonClass() {}
   virtual WidgetClass classPointer() { return xmDrawnButtonWidgetClass; }
   virtual _XtString className()      { return (_XtString) "XmDrawnButton"; }
 public:
   /* callbacks */
   void activateCallback(XtCallbackProc fp, XtPointer data = NULL)
                                                         { XARM_SET_CALLBACK(XmNactivateCallback); }
   void armCallback(XtCallbackProc fp, XtPointer data = NULL)
                                                         { XARM_SET_CALLBACK(XmNarmCallback); }
   void disarmCallback(XtCallbackProc fp, XtPointer data = NULL)
                                                         { XARM_SET_CALLBACK(XmNdisarmCallback); }
   void exposeCallback(XtCallbackProc fp, XtPointer data = NULL)
                                                         { XARM_SET_CALLBACK(XmNexposeCallback); }
   void resizeCallback(XtCallbackProc fp, XtPointer data = NULL)
                                                         { XARM_SET_CALLBACK(XmNresizeCallback); }

   /* resources */
   void multiClick(unsigned char val)    { XARM_SET_VALUE(XmNmultiClick); }
   unsigned char multiClick() const      { XARM_GET_VALUE(unsigned char, XmNmultiClick); }
   void pushButtonEnabled(Boolean val)   { XARM_SET_VALUE(XmNpushButtonEnabled); }
   Boolean pushButtonEnabled() const     { XARM_GET_VALUE(Boolean, XmNpushButtonEnabled); }
   void shadowType(unsigned char val)    { XARM_SET_VALUE(XmNshadowType); }
   unsigned char shadowType() const      { XARM_GET_VALUE(unsigned char, XmNshadowType); }
};

typedef XarmRawWidget<DrawnButtonClass, true> DrawnButton;
   
#endif
