/* $Id: Dial.h,v 1.4 1999/11/06 05:50:58 glgay Exp $ */
/*
 Copyright (C) 1998, 1999 Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_dial_h)
#define xarm_dial_h

/*
 * Warning:  These classes diverge from the Motif 1.2 standard GUI.
 */

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Primitive.h>
#include <Xmext/Dial.h>

class DialClass : public PrimitiveClass {
 protected:
   DialClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer() { return xmDialWidgetClass; }
   virtual _XtString className()      { return (_XtString) "XmDial"; }

 public:
   /* resources */
   void          minimum(int val)                        { XARM_SET_VALUE(XmNminimum); }
   int           minimum() const                         { XARM_GET_VALUE(int, XmNminimum); }
   void          maximum(int val)                        { XARM_SET_VALUE(XmNmaximum); }
   int           maximum() const                         { XARM_GET_VALUE(int, XmNmaximum); }
   void          value(int val)                          { XARM_SET_VALUE(XmNvalue); }
   int           value() const                           { XARM_GET_VALUE(int, XmNvalue); }
   void          tickIncrement(int val)                  { XARM_SET_VALUE(XmNtickIncrement); }
   int           tickIncrement() const                   { XARM_GET_VALUE(int, XmNtickIncrement); }
   void          tickSize(int val)                       { XARM_SET_VALUE(XmNtickSize); }
   int           tickSize() const                        { XARM_GET_VALUE(int, XmNtickSize); }
   void          arcMargin(int val)                      { XARM_SET_VALUE(XmNarcMargin); }
   int           arcMargin() const                       { XARM_GET_VALUE(int, XmNarcMargin); }
   void          borderMargin(int val)                   { XARM_SET_VALUE(XmNborderMargin); }
   int           borderMargin() const                    { XARM_GET_VALUE(int, XmNborderMargin); }
   void          processingDirection(unsigned char val)  { XARM_SET_VALUE(XmNprocessingDirection); }
   unsigned char processingDirection() const             { XARM_GET_VALUE(unsigned char, XmNprocessingDirection); }
   void          fill(Boolean val)                       { XARM_SET_VALUE(XmNfill); }
   Boolean       fill() const                            { XARM_GET_VALUE(Boolean, XmNfill); }
   void          showValue(Boolean val)                  { XARM_SET_VALUE(XmNshowValue); }
   Boolean       showValue() const                       { XARM_GET_VALUE(Boolean, XmNshowValue); }
   void          showMinMax(Boolean val)                 { XARM_SET_VALUE(XmNshowMinMax); }
   Boolean       showMinMax() const                      { XARM_GET_VALUE(Boolean, XmNshowMinMax); }
   void          showPercentage(Boolean val)             { XARM_SET_VALUE(XmNshowPercentage); }
   Boolean       showPercentage() const                  { XARM_GET_VALUE(Boolean, XmNshowPercentage); }
   void          showHub(Boolean val)                    { XARM_SET_VALUE(XmNshowHub); }
   Boolean       showHub() const                         { XARM_GET_VALUE(Boolean, XmNshowHub); }
   void          style(const DialStyle val)              { XARM_SET_VALUE(XmNstyle); }
   DialStyle     style() const                           { XARM_GET_VALUE(DialStyle, XmNstyle); }
};

typedef XarmFuncWidget<DialClass, XmCreateDial, true> Dial;

#endif
