/* $Id: CDEComboBox.h,v 1.7 1999/11/06 05:50:57 glgay Exp $ */
/*
 Copyright (C) 1997, 1999 Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#if !defined(xarm_cdecombobox_h)
#define xarm_cdecombobox_h

#include <Dt/ComboBox.h>

class ComboBoxClass : public ManagerClass {
 protected:
   ComboBoxClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer() { return dtComboBoxWidgetClass; }
   virtual _XtString className() { return (_XtString) "DtComboBox"; }

 public:
   /* callbacks */
   void selectionCallback(XtCallbackProc fp, XtPointer data = NULL)
     { XARM_SET_CALLBACK(DtNselectionCallback); }

   /* resources */
   /* read only after construction */
   unsigned char comboBoxType() const { XARM_GET_VALUE(unsigned char, DtNcomboBoxType); }
   void marginHeight(Dimension val)   { XARM_SET_VALUE(DtNmarginHeight); }
   Dimension marginHeight() const     { XARM_GET_VALUE(Dimension, DtNmarginHeight); }
   void marginWidth(Dimension val)    { XARM_SET_VALUE(DtNmarginWidth); }
   Dimension marginWidth() const      { XARM_GET_VALUE(Dimension, DtNmarginWidth); }
   void selectedItem(const char *str) { XARM_SET_STRING(DtNselectedItem); }
   char *selectedItem() const         { XARM_GET_STRING_NF(DtNselectedItem); }
   void selectedPosition(int val)     { XARM_SET_VALUE(DtNselectedPosition); }
   int selectedPosition() const       { XARM_GET_VALUE(int, DtNselectedPosition); }

   /* convenience routines */
   Widget list() const;    /* return list widget */

   /* CDE ComboBox functions */
   void add(const char *str, int pos = 0, Boolean unique = False);
   void del(int);
   void setItem(const char *);

   /* The clear function was added by popular demand. */
   void clear();     /* Clear the list */
   
   /* extra functionality */
   /* 
    * listObject()
    * This routine returns the list wrapper object for the list widget. 
    */
   ListClass *listObject() const; 
   
};

typedef XarmFuncWidget<ComboBoxClass, DtCreateComboBox, true> ComboBox;

#endif
