/* $Id: AppContext.h,v 1.4 1999/11/06 05:50:57 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1998, 1999 Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_appcontext_h)
#define xarm_appcontext_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/ApplicationS.h>
#include <Xarm/ImageCache.h>


/*
*  Author's note:  Although it is not stated (to my knowledge), the
*  AppContext inherits from the toplevelShellWidget sort of.  
*/
class AppContextClass : public ApplicationShellClass {
 private:
   XtAppContext app_context;
   bool doneProcessing;

   /*
    * Installs extra functionality hooks
    * File names for Pixmaps types can be specified in resource files
    * This is called right after AppInit routine.
    */
 protected:
   void registerConverters() { XarmRegisterConverters(); }

   void appContext(const XtAppContext ac) { app_context = ac; }
   AppContextClass() {}
 public:
   void addActions(const XtActionList actions, const Cardinal no)
     { XtAppAddActions(appContext(), actions, no); }
   void addConverter(_XtString from_type, 
                     _XtString to_type, 
                     XtConverter converter,
                     XtConvertArgList convert_args, 
                     Cardinal no_args)
     {  XtAppAddConverter(appContext(),
			  from_type,
			  to_type,
			  converter,
			  convert_args,
			  no_args); }
   XtInputId addInput(int source,XtPointer condition, XtInputCallbackProc proc,
                      XtPointer client_data)
     { return XtAppAddInput(appContext(), source, condition, proc, client_data); }
   XtIntervalId addTimeOut(unsigned long interval, XtTimerCallbackProc proc, 
                           XtPointer client_data)
     { return XtAppAddTimeOut(appContext(), interval, proc, client_data); }
   XtWorkProcId addWorkProc(XtWorkProc proc, XtPointer client_data)
     { return XtAppAddWorkProc(appContext(), proc, client_data); }
   Boolean dispatchEvent(XEvent *event) { return XtDispatchEvent(event); }
   void error(const _XtString msg) { XtAppError(appContext(), msg); }
   void errorMsg(_XtString name, 
                 _XtString type, 
                 _XtString _class, 
                 _XtString _default,
                 _XtString *params, 
                 Cardinal *no)
     { XtAppErrorMsg(appContext(), name, type, _class, _default, params, no); }
   XrmDatabase *getErrorDatabase() { return XtAppGetErrorDatabase(appContext()); }
   void getErrorDatabaseText(char *name, char *type, char *_class,
                             char *_default, char *buffer_return, int nbytes, 
                             XrmDatabase database)
     {  XtAppGetErrorDatabaseText(appContext(),name,type,_class,_default,
				  buffer_return, nbytes, database); }
   unsigned long getSelectionTimeout() const
     { return XtAppGetSelectionTimeout(appContext()); }
   void mainLoop();
   void nextEvent(XEvent * event_return) { XtAppNextEvent(appContext(),event_return); }
   void processEvent(XtInputMask mask) { XtAppProcessEvent(appContext(),mask); }
   Boolean peekEvent(XEvent * event_return)
     { return XtAppPeekEvent(appContext(), event_return); }
   XtInputMask pending() { return XtAppPending(appContext()); }
   
   void removeInput(XtInputId id) { XtRemoveInput(id); }
   void removeTimeOut(XtIntervalId timer) { XtRemoveTimeOut(timer); }
   void removeWorkProc(XtWorkProcId id) { XtRemoveWorkProc(id); }
   void setErrorHandler(XtErrorHandler handler)
     { XtAppSetErrorHandler(appContext(), handler); }
   void setErrorMsgHandler(XtErrorMsgHandler handler)
     { XtAppSetErrorMsgHandler(appContext(), handler); }
   void setSelectionTimeout(unsigned long timeout)
     { XtAppSetSelectionTimeout(appContext(), timeout); }
   void setWarningHandler(XtErrorHandler handler)
     { XtAppSetWarningHandler(appContext(), handler); }
   void setWarningMsgHandler(XtErrorMsgHandler handler)
     { XtAppSetWarningMsgHandler(appContext(), handler); }
   void warning(_XtString msg) { XtAppWarning(appContext(), msg); }
   void warningMsg(_XtString name, 
                   _XtString type, 
                   _XtString _class, 
                   _XtString _default,
                   _XtString *params, Cardinal *no)
     { XtAppWarningMsg(appContext(), name, type, _class, _default, params, no); }
   
   /* extras */
   XtAppContext appContext() const { return app_context; }
   operator XtAppContext() const   { return app_context; }

   // termPending() tells whether we are about to exit.
   // This might be useful to someone.
   bool termPending() const { return doneProcessing; }

   // Calling quit(false) exits the mainLoop function.
   // Calling quit(true)  calls ::exit()
   void quit(bool now = false);
};

class AppContext : public AppContextClass {
 public:
   AppContext(const char *app_class,
              XrmOptionDescList options, 
              Cardinal no, 
              int &argc_in_out, 
              char **argv_in_out, 
              _XtString *fallbacks = NULL);

};


#endif
