/* $Id: main.C,v 1.6 1999/11/06 05:50:57 glgay Exp $ */
/*
 * Copyright (c) 1994, Jettero Heller
 * Copyright (c) 1997, Peter G. Williams
 * Copyright (c) 1997, Gerald L. Gay
 * 
 * You may distribute this source code under the terms of the license
 * in the COPYING file.
 * 
 */

/* Include(s) */
#include <string.h>
#include <stdlib.h>

#if defined(XARM_HAS_NEWHEADERS)
#include <iostream>
#else
#include <iostream.h>
#endif

#include <Xarm/AppContext.h>
#include <Xarm/Form.h>
#include <Xarm/TextF.h>
#include <Xarm/SpinBox.h>
#include <Xarm/Label.h>
#include <Xarm/MessageB.h>
#include <Xarm/Callback.h>
#include <Xarm/XarmArg.h>

/* Declaration(s) */
class Application: public AppContext
{
 private:
   void exit(Widget,XtPointer,XtPointer);
   void onExit(Widget,XtPointer,XtPointer);

   void createWidgets();

 public:
   Application(char *app_class,int &argc_in_out, char **argv_in_out);
};

char *title = "SpinBox Example";

const char *spinChoices[] = { "Red", "Green", "Blue", "Purple",
                              "Yellow", "Pink", "Brown", "Black" };

char *basename(char *name)
{
   char *s;

   if((s=strrchr(name,'/'))!=NULL)
   {
      s++;
   }
   else
   {
      s = name;
   }	
   return s;
}

/* CDE is very verbose about resize errors    */
/* we trap everything here to keep the output */
/* of the program under our control.          */
void WarningHandler(String msg)
{
}

int
main (int argc, char **argv)
{
   // initialize application 
   Application app(basename(argv[0]),argc,argv);

   // realize application
   app.realize();

   // start the main loop 
   app.mainLoop();

   // exit code just in case we get here.
   exit(EXIT_SUCCESS);
   return EXIT_SUCCESS;  /* SOME compilers like a return statement */
}

Application::Application(char *app_class, int &argc_in_out, char **argv_in_out):
   AppContext(app_class, NULL, 0, argc_in_out, argv_in_out)
{

   // install window manager message handler(s)
   Atom proto = addWMProtocol(XA_WM_DELETE_WINDOW);
   addWMProtocolCallback(widget(), proto, (p_msg)&Application::onExit);
   XtSetWarningHandler(WarningHandler);

   title(::title);

   // install window(s) into the application window 

   createWidgets();

}

// The CDE and Motif 2.0 versions of the SpinBox are
// sufficiently different that each gets it's own
// version of the create routine.

//---------------------------------------------------
#if XmVERSION >= 2 && !defined(XARM_HAS_CDE)

// The Motif 2 SpinBox is a manager widget that gets
// information from it's children on what to do.
// As such, after you create the spinbox, you then
// create one or more TextField children inside it.

void Application::createWidgets()
{
    XarmArg args;

    Form *mainForm = new Form(widget());

    args(XmNarrowLayout,     XmARROWS_SPLIT)
        (XmNtopAttachment,   XmATTACH_FORM)
        (XmNleftAttachment,  XmATTACH_FORM)
        (XmNrightAttachment, XmATTACH_FORM);

    SpinBox *spin1 = new SpinBox(mainForm->widget(), args, "Spin1");

    args.reset();

    // Note that the spinBoxChildType must be set during creation.
    // Also, I was unable to change maximumValue and minimumValue
    // after creation even though the documentation says that it
    // is supposed to work.

    args(XmNspinBoxChildType, XmNUMERIC)
        (XmNminimumValue,     5)
        (XmNmaximumValue,     27)
        (XmNincrementValue,   2)
        (XmNposition,         3);

    TextField *tf1 = new TextField(spin1->widget(), args, "tf1");
    tf1->columns(15);
    tf1->editable(False);

    spin1->manage();

    args.reset();
    args(XmNtopAttachment,    XmATTACH_WIDGET)
        (XmNtopWidget,        spin1->widget())
        (XmNleftAttachment,   XmATTACH_FORM)
        (XmNrightAttachment,  XmATTACH_FORM)
        (XmNbottomAttachment, XmATTACH_FORM)
        (XmNarrowLayout,      XmARROWS_SPLIT);

    SpinBox *spin2 = new SpinBox(mainForm->widget(), args, "Spin2");

    // For the XmSTRING type spinbox, I was not able to get it
    // to work unless I set the numValues property at creation.
    // This might be a problem in my version of Motif.  If anyone
    // else gets it to work, I'd be interested in hearing about it.

    args.reset();
    args(XmNspinBoxChildType, XmSTRING)
        (XmNcolumns,          15)
        (XmNeditable,         FALSE)
        (XmNnumValues,        8);

    TextField *tf2 = new TextField(spin2->widget(), args, "tf2");

    spin2->values(tf2->widget(), spinChoices, 8);
    spin2->position(tf2->widget(), 3);

    spin2->manage();

    mainForm->manage();
}

#endif

// In CDE, the SpinBox is a single widget. You don't
// create TextField children for it.  It will create
// it's own. Also, I was not able to dynamically set
// the DtNvalues for the DtSTRING SpinBox.  I had to
// set it at creation time.  Your mileage may vary.
//---------------------------------------------------
#ifdef XARM_HAS_CDE

void Application::createWidgets()
{
    XarmArg args;

    Form *mainForm = new Form(widget());

    args(DtNarrowLayout,      DtARROWS_SPLIT)
        (DtNspinBoxChildType, DtNUMERIC)
        (XmNeditable,         FALSE)
        (XmNtopAttachment,    XmATTACH_FORM)
        (XmNleftAttachment,   XmATTACH_FORM)
        (XmNrightAttachment,  XmATTACH_FORM);

    SpinBox *spin1 = new SpinBox(mainForm->widget(), args, "Spin1");

    spin1->minimumValue(5);
    spin1->maximumValue(27);
    spin1->incrementValue(2);
    spin1->position(3);

    spin1->manage();

    XmString *xmstr = new XmString[8];

    for (int i = 0; i < 8; ++i)
        xmstr[i] = cvtStringToXmString(spinChoices[i]);

    args.reset();
    args(XmNtopAttachment,    XmATTACH_WIDGET)
        (XmNtopWidget,        spin1->widget())
        (XmNleftAttachment,   XmATTACH_FORM)
        (XmNrightAttachment,  XmATTACH_FORM)
        (XmNbottomAttachment, XmATTACH_FORM)
        (XmNeditable,         FALSE)
        (DtNspinBoxChildType, DtSTRING)
        (DtNvalues,           xmstr)
        (DtNnumValues,        8)
        (DtNarrowLayout,      DtARROWS_SPLIT);

    SpinBox *spin2 = new SpinBox(mainForm->widget(), args, "Spin2");

    for (int i = 0; i < 8; ++i)
        XmStringFree(xmstr[i]);

    delete [] xmstr;

    spin2->position(3);

    spin2->manage();

    mainForm->manage();
}

#endif

// Stub for versions without the SpinBox
//---------------------------------------------------
#ifndef XARM_HAS_SPINBOX

void Application::createWidgets()
{
   new Label(widget(),"No SpinBox Support in this version of Motif");
}

#endif

void
Application::exit(Widget, XtPointer, XtPointer)
{
   quit();
}

void 
Application::onExit(Widget w, XtPointer, XtPointer)
{

   QuestionDialog *diag = new QuestionDialog(w,"Do you really want to quit?");
   addCallback(diag->widget(), XmNokCallback,(p_msg)&Application::exit);
   diag->dialogTitle("Exit Dialog");
   diag->manage();
}

