/*
 * Copyright (c) 1994, Jettero Heller
 *
 * You may distribute this source code under the terms of the license
 * in the COPYING file.
 *
 */

/* Include(s) */
#include <Xarm/PasswordF.h>
#include <string.h>
#include <stdlib.h>
#include <Xarm/AppContext.h>
#include <Xarm/PushB.h>
#include <Xarm/ToggleB.h>
#include <Xarm/RowColumn.h>
#include <Xarm/MessageB.h>

/* The easiest way to specify ToolTip colors is in resources */

_XtString fallbacks[] = {
    "*tipForeground: black",
    "*tipBackground: yellow",
    NULL
};

/* Declaration(s) */
class Application: public AppContext
{
 private:
   void onActivate(Widget,XtPointer,XtPointer);
   void onExit(Widget,XtPointer,XtPointer);
   void onToggleEdit(Widget,XtPointer,XtPointer);
   void exit(Widget,XtPointer,XtPointer);

   PasswordField *field;
   PushButton *button;
   ToggleButton *canPaste;
 public:
   Application(char *app_class,int &argc_in_out, char **argv_in_out);
};

char *basename(char *name)
{
   char *s;

   if((s=strrchr(name,'/'))!=NULL)
   {
      s++;
   }
   else
   {
      s = name;
   }
   return s;
}

int
main (int argc, char **argv)
{
   // initialize application
   Application app(basename(argv[0]),argc,argv);

   // realize application
   app.realize();

   // start the main loop
   app.mainLoop();

   // exit code just in case we get here.
   exit(EXIT_SUCCESS);
   return EXIT_SUCCESS;  /* SOME compilers like a return statement */
}

Application::Application(char *app_class, int &argc_in_out, char **argv_in_out):
   AppContext(app_class, NULL, 0, argc_in_out, argv_in_out, fallbacks)
{

   // install window manager message handler(s)
   Atom proto = addWMProtocol(XA_WM_DELETE_WINDOW);
   addWMProtocolCallback(widget(),proto,(p_msg)&Application::onExit);

   title(app_class);

   // install window(s) into the application window
   RowColumn *rc = new RowColumn(widget());
   field = new PasswordField(rc->widget());
   field->addToolTip("Type text here that will not be echoed");
   button = new PushButton(rc->widget(),"Decrypt");
   button->addToolTip("Decrypt typed in text");
   canPaste = new ToggleButton(rc->widget(), "Enable Cut/Paste & Editing");
   canPaste->addToolTip("Toggles editing features");
   addCallback(button->widget(),
               XmNactivateCallback,
               (p_msg) &Application::onActivate);

   addCallback(canPaste->widget(),
	       XmNvalueChangedCallback,
	       (p_msg) &Application::onToggleEdit);

   rc->manage();
}

void
Application::onActivate(Widget w, XtPointer, XtPointer)
{

   static char fillChars[] = { '*', '#', '$', '%', '-', '+', '@', 'X', '\0' };
   static int nextChar = 0;

   MessageDialog *diag = new MessageDialog(w,(char *)field->password());

   diag->dialogTitle("The Password Field's Contents:");
   diag->manage();
   if (fillChars[nextChar + 1] == '\0') nextChar = 0;
   else                                 ++nextChar;
   field->fillChar(fillChars[nextChar]);
}

void Application::onToggleEdit(Widget, XtPointer, XtPointer)
{
    field->enablePaste(canPaste->set());
}

void
Application::exit(Widget, XtPointer, XtPointer)
{
   quit();
}

void
Application::onExit(Widget w, XtPointer, XtPointer)
{

   QuestionDialog *diag = new QuestionDialog(w,"Do you really want to quit?");

   diag->dialogTitle("Exit Dialog");
   addCallback(diag->widget(),XmNokCallback,(p_msg)&Application::exit);
   diag->manage();
}

