/* $Id: main.C,v 1.8 1999/11/06 05:50:56 glgay Exp $ */
/*
 * Copyright (c) 1994, Jettero Heller
 * Copyright (c) 1997, Peter G. Williams
 * Copyright (c) 1997, Gerald L. Gay
 * 
 * You may distribute this source code under the terms of the license
 * in the COPYING file.
 * 
 */

/* Include(s) */
#include <string.h>
#include <stdlib.h>
#include <Xarm/AppContext.h>
#include <Xarm/ComboBox.h>
#include <Xarm/Label.h>
#include <Xarm/MessageB.h>
#include <Xarm/Callback.h>
#include <Xarm/XarmArg.h>

#if defined(XARM_HAS_NEWHEADERS)
#include <iostream>
#else
#include <iostream.h>
#endif

#if defined(XARM_HAS_NAMESPACES)
using namespace std;
#endif

/* Declaration(s) */
class Application: public AppContext
{
 private:
   void exit(Widget,XtPointer,XtPointer);
   void onExit(Widget,XtPointer,XtPointer);

   void onItemSelected(Widget, XtPointer, XtPointer);

   int curList;
   int inSelectionCallback;

#ifdef XARM_HAS_COMBOBOX

   ComboBox *myCombo;

#endif
  
 public:
   Application(char *app_class,int &argc_in_out, char **argv_in_out);
};

char *title = "ComboBox example";

char *fooStrings[] = { "foo1", "foo2", "foo3",
		       "foo4", "foo5", "foo6",
		       "foo7", "foo8", "foo9" };

char *barStrings[] = { "bar1", "bar2", "bar3",
		       "bar4", "bar5", "bar6",
		       "bar7", "bar8", "bar9" };

#define NUM_ENTRIES 9

char *basename(char *name)
{
   char *s;

   if((s=strrchr(name,'/'))!=NULL)
   {
      s++;
   }
   else
   {
      s = name;
   }	
   return s;
}

/* CDE is very verbose about resize errors    */
/* we trap everything here to keep the output */
/* of the program under our control.          */
void WarningHandler(String msg)
{
}

int
main (int argc, char **argv)
{
   // initialize application 
   Application app(basename(argv[0]),argc,argv);

   // realize application
   app.realize();

   // start the main loop 
   app.mainLoop();

   // exit code just in case we get here.
   exit(EXIT_SUCCESS);
   return EXIT_SUCCESS;  /* SOME compilers like a return statement */
}

Application::Application(char *app_class, int &argc_in_out, char **argv_in_out):
   AppContext(app_class, NULL, 0, argc_in_out, argv_in_out)
{

   // install window manager message handler(s)
   Atom proto = addWMProtocol(XA_WM_DELETE_WINDOW);
   addWMProtocolCallback(widget(), proto, (p_msg)&Application::onExit);
   XtSetWarningHandler(WarningHandler);

   title(::title);

   // Set the current List index

   curList = 0;
   inSelectionCallback = 0;

   // install window(s) into the application window 

#ifdef XARM_HAS_COMBOBOX

   XarmArg args;

#if XmVERSION >= 2 && !defined(XARM_HAS_CDE)

   args(XmNcomboBoxType,     XmDROP_DOWN_LIST);
   args(XmNvisibleItemCount, 5);

#else

   args(DtNcomboBoxType,     DtDROP_DOWN_LIST);
   args(DtNvisibleItemCount, 5);

#endif

   myCombo = new ComboBox(widget(), args, "myCombo");

   char **comboListItems = (curList) ? barStrings : fooStrings;

   for (int x = 0; x < NUM_ENTRIES; ++x)
       myCombo->add(comboListItems[x]);

   myCombo->selectedItem(comboListItems[0]);

#if XmVERSION >= 2 && !defined(XARM_HAS_CDE)

   addCallback(myCombo->widget(), XmNselectionCallback, (p_msg)&Application::onItemSelected);

#else

   addCallback(myCombo->widget(), DtNselectionCallback, (p_msg)&Application::onItemSelected);

#endif

#else  // XARM_HAS_COMBOBOX not defined

   new Label(widget(),"No ComboBox Support in this version of Motif");

#endif
}

void Application::onItemSelected(Widget, XtPointer, XtPointer)
{
#ifdef XARM_HAS_COMBOBOX

    if (inSelectionCallback) return;

    inSelectionCallback = 1;

    // Swap lists...

    curList = !curList;

    cout << "Current selection is: " << myCombo->selectedItem() << endl;

    char **comboListItems = (curList) ? barStrings : fooStrings;

    myCombo->clear();

    for (int x = 0; x < NUM_ENTRIES; ++x)
        myCombo->add(comboListItems[x]);

    myCombo->selectedItem(comboListItems[0]);

    inSelectionCallback = 0;

#endif
}

void
Application::exit(Widget, XtPointer, XtPointer)
{
   quit();
}

void 
Application::onExit(Widget w, XtPointer, XtPointer)
{

   QuestionDialog *diag = new QuestionDialog(w,"Do you really want to quit?");
   addCallback(diag->widget(), XmNokCallback,(p_msg)&Application::exit);
   diag->dialogTitle("Exit Dialog");
   diag->manage();
}

