/* $Id: Page.c,v 1.1.1.1 1997/03/19 13:32:22 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#include <Xmext/PageP.h>


/* PropertyPage widget */
#define Unused(x) (void)(x)
#define Offset(field) XtOffsetOf(XmPropertyPageRec, property_page.field)
#define BB_Offset(field) XtOffsetOf(XmPropertyPageRec, bulletin_board.field)
#define MGR_Offset(field) XtOffsetOf(XmPropertyPageRec, manager.field)

/* local declarations */
static void change_managed(Widget w);
static void class_initialize();
static void class_part_initialize(WidgetClass class);
static void destroy(Widget w);
#if 0
static void expose(Widget w, XEvent *event, Region region);
#endif
static XtGeometryResult geometry_manager(Widget w, 
                                         XtWidgetGeometry *request, 
                                         XtWidgetGeometry *reply);
static void initialize(Widget request, 
                       Widget c_new,
                       ArgList args,
                       Cardinal *num_args);
static void layout(XmPropertyPageWidget w);
static XtGeometryResult query_geometry(Widget w, 
                                      XtWidgetGeometry *proposed, 
                                      XtWidgetGeometry *answer);
/* realize sets the active page & tab if not null */
static void realize(Widget w,
                    XtValueMask *value_mask,
                    XSetWindowAttributes *attributes);
static Boolean set_values(Widget current, 
                          Widget request, 
                          Widget c_new, 
                          ArgList args,
                          Cardinal *num_args);

/* ========================================================================== */
/* Resources for the Property Page class */
static XtResource resources[] = {

   {
     XmNapplyCallback,
     XmCCallback, 
     XtRCallback,
     sizeof(XtCallbackList),
     Offset(apply_callback),
     XmRImmediate,
     NULL
   },

   {
     XmNcancelCallback,
     XmCCallback, 
     XtRCallback,
     sizeof(XtCallbackList),
     Offset(cancel_callback),
     XmRImmediate,
     NULL
   },

   {
     XmNkillActiveCallback,
     XmCCallback, 
     XtRCallback,
     sizeof(XtCallbackList),
     Offset(kill_active_callback),
     XmRImmediate,
     NULL
   },

   {
     XmNokCallback,
     XmCCallback, 
     XtRCallback,
     sizeof(XtCallbackList),
     Offset(ok_callback),
     XmRImmediate,
     NULL
   },

   {
     XmNsetActiveCallback,
     XmCCallback, 
     XtRCallback,
     sizeof(XtCallbackList),
     Offset(set_active_callback),
     XmRImmediate,
     NULL
   },

   /* override bulletin board defaults */
   {
     XmNshadowType,
     XmCShadowType,
     XmRShadowType,
     sizeof(unsigned char),
     BB_Offset(shadow_type),
     XmRImmediate, 
     (XtPointer) XmSHADOW_OUT
   },
   /* override manager defaults */
   {
     XmNshadowThickness,
     XmCShadowThickness,
     XmRHorizontalDimension,
     sizeof(Dimension),
     MGR_Offset(shadow_thickness),
     XmRImmediate, 
     (XtPointer)2
   },
};

/* ========================================================================== */
/* Class record */

XmPropertyPageClassRec xmPropertyPageClassRec = {
   /* Core class part */
   {
      (WidgetClass) &xmBulletinBoardClassRec, /* superclass */
      "XmPropertyPage",                       /* class_name */
      sizeof(XmPropertyPageRec),              /* widget_size */
      class_initialize,                       /* class_initialize */
      class_part_initialize,                  /* class_part_initialize */
      FALSE,                                  /* class_inited */
      initialize,                             /* initialize */
      NULL,                                   /* initialize_hook */
      realize,                                /* realize */
      NULL,                                   /* actions */
      0,                                      /* num_actions */
      resources,                              /* resources */
      XtNumber(resources),                    /* num_resources */
      NULLQUARK,                              /* xrm_class */
      TRUE,                                   /* compress_motion */
      XtExposeCompressMultiple,               /* compress_exposure */
      TRUE,                                   /* compress_enterleave */
      FALSE,                                  /* visible_interest */
      destroy,                                /* destroy */
      NULL,                                   /* resize */
      XtInheritExpose,                        /* expose */
      set_values,                             /* set_values */
      NULL,                                   /* set_values_hook */
      XtInheritSetValuesAlmost,               /* set_values_almost */
      NULL,                                   /* get_values_hook */
      NULL,                                   /* accept_focus */
      XtVersion,                              /* version */
      NULL,                                   /* callback offsets */
      XtInheritTranslations,                  /* tm_table */
      query_geometry,                         /* query_geometry */
      NULL,                                   /* display_accelerator */
      NULL                                    /* extension */ 
   },
   /* Composite class part */
   {
      geometry_manager,       /* geometry manager */
      change_managed,         /* change_managed */
      XtInheritInsertChild,   /* insert_child */ 
      XtInheritInsertChild,   /* delete_child */ 
      NULL                    /* extension */ 
   },
   /* Constraint class part */
   {
      NULL,      /* FIX ME */ /* subresources */
      0,         /* FIX ME */ /* subresource_count */
      0,         /* FIX ME */ /* constraint_size */
      NULL,      /* FIX ME */ /* initialize */
      NULL,      /* FIX ME */ /* destroy */
      NULL,      /* FIX ME */ /* set_values */
      NULL                    /* extension */ 
   },
   /* XmManager class part */
   {
      NULL,                   /* translations */ 
      NULL,                   /* syn_resources */ 
      0,                      /* num_syn_resources */
      NULL,                   /* syn_constraint_resources */ 
      0,                      /* num_syn_constraint_resources */
      XmInheritParentProcess, /* parent process */
      NULL                    /* extension */ 
   },
   /* XmBulletin class part */
   {
      (Dimension) NULL                    /* extension */ 
   },
   /* XmPropertyPage class part */
   {
      NULL                    /* extension */ 
   }
};

WidgetClass xmPropertyPageWidgetClass = (WidgetClass) &xmPropertyPageClassRec;

/* ========================================================================== */
/* functions */

static void 
change_managed(Widget w)
{
   layout((XmPropertyPageWidget)w);
}

static void
class_initialize()
{
}

static void
class_part_initialize(WidgetClass widget_class)
{
   Unused(widget_class);
}

static void
destroy(Widget w)
{
   Unused(w);
}

#if 0
static void 
expose(Widget w, XEvent *event, Region region)
{
   /* FIX ME */
   Unused(w);
   Unused(event);
   Unused(region);
}
#endif

static XtGeometryResult 
geometry_manager(Widget w, XtWidgetGeometry *request, XtWidgetGeometry *reply)
{
   /* FIX ME */
   Unused(w);
   Unused(request);
   Unused(reply);
   return (XtGeometryResult) NULL;
}

static void
initialize(Widget request,
           Widget c_new,
           ArgList args,
           Cardinal *num_args)
{
   /* nothing to do */
   Unused(request);
   Unused(c_new);
   Unused(args);
   Unused(num_args);
}

static void
layout(XmPropertyPageWidget w)
{
   /* FIX ME */
   Unused(w);
}

static XtGeometryResult 
query_geometry(Widget w, XtWidgetGeometry *proposed, XtWidgetGeometry *answer)
{
   /* FIX ME */
   Unused(w);
   Unused(proposed);
   Unused(answer);
   return (XtGeometryResult) NULL;
}

/* realize sets the active page & tab if not null */
static void realize(Widget w,
                    XtValueMask *value_mask,
                    XSetWindowAttributes *attributes)
{
   #define superclass (&xmBulletinBoardClassRec)
   (*superclass->core_class.realize)(w, value_mask, attributes);  
   #undef superclass

   /* FIX ME */
   Unused(w);
   Unused(value_mask);
   Unused(attributes);
}

static Boolean 
set_values(Widget old, 
           Widget request, 
           Widget c_new, 
           ArgList args,
           Cardinal *num_args)
{
   /* do nothing */
   Unused(old);
   Unused(request);
   Unused(c_new);
   Unused(args);
   Unused(num_args);
   return False;
}

/* ========================================================================== */

/*
 * XmCreatePropertyPage
 *
 * Creates an instance of a particular widget class or compound object.
 */
Widget 
XmCreatePropertyPage(Widget parent, char *name, ArgList arglist,
                    Cardinal cnt)
{
   return XtCreateWidget(name, 
                         xmPropertyPageWidgetClass,
                         parent, 
                         arglist, 
                         cnt);
}

/* === Remove everything below this line === */

