/*
 Copyright (C) 1998, Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#include <Xarm/Xarm.h>

#ifdef XARM_HAS_XBAE

#include <Xarm/XarmMatrix.h>

void MatrixClass::defaultActionCallback(XtCallbackProc funcp, XtPointer data) {
    addCallback( XmNdefaultActionCallback, funcp, data);
}

void MatrixClass::drawCellCallback(XtCallbackProc funcp, XtPointer data) {
    addCallback( XmNdrawCellCallback, funcp, data);
}

void MatrixClass::enterCellCallback(XtCallbackProc funcp, XtPointer data) {
    addCallback( XmNenterCellCallback, funcp, data);
}

void MatrixClass::labelActivateCallback(XtCallbackProc funcp, XtPointer data) {
    addCallback( XmNlabelActivateCallback, funcp, data);
}

void MatrixClass::leaveCellCallback(XtCallbackProc funcp, XtPointer data) {
    addCallback( XmNleaveCellCallback, funcp, data);
}

void MatrixClass::modifyVerifyCallback(XtCallbackProc funcp, XtPointer data) {
    addCallback( XmNmodifyVerifyCallback, funcp, data);
}

void MatrixClass::processDragCallback(XtCallbackProc funcp, XtPointer data) {
    addCallback( XmNprocessDragCallback, funcp, data);
}

void MatrixClass::resizeCallback(XtCallbackProc funcp, XtPointer data) {
    addCallback( XmNresizeCallback, funcp, data);
}

void MatrixClass::resizeColumnCallback(XtCallbackProc funcp, XtPointer data) {
    addCallback( XmNresizeColumnCallback, funcp, data);
}

void MatrixClass::selectCellCallback(XtCallbackProc funcp, XtPointer data) {
    addCallback( XmNselectCellCallback, funcp, data);
}

void MatrixClass::traverseCellCallback(XtCallbackProc funcp, XtPointer data) {
    addCallback( XmNtraverseCellCallback, funcp, data);
}

void MatrixClass::writeCellCallback(XtCallbackProc funcp, XtPointer data) {
    addCallback( XmNwriteCellCallback, funcp, data);
}

void MatrixClass::allowColumnResize(Boolean b)
{
    XtVaSetValues(widget(), XmNallowColumnResize, b, NULL);
}

Boolean MatrixClass::allowColumnResize() const
{
    Boolean b;

    XtVaGetValues(widget(), XmNallowColumnResize, &b, NULL);

    return b;
}

void MatrixClass::altRowCount(int i)
{
    XtVaSetValues(widget(), XmNaltRowCount, i, NULL);
}

int MatrixClass::altRowCount() const
{
    int i;

    XtVaGetValues(widget(), XmNaltRowCount, &i, NULL);

    return i;
}

void MatrixClass::boldLabels(Boolean b)
{
    XtVaSetValues(widget(), XmNboldLabels, b, NULL);
}

Boolean MatrixClass::boldLabels() const
{
    Boolean b;

    XtVaGetValues(widget(), XmNboldLabels, &b, NULL);

    return b;
}

void MatrixClass::buttonLabels(Boolean b)
{
    XtVaSetValues(widget(), XmNbuttonLabels, b, NULL);
}

Boolean MatrixClass::buttonLabels() const
{
    Boolean b;

    XtVaGetValues(widget(), XmNbuttonLabels, &b, NULL);

    return b;
}

void MatrixClass::buttonLabelBackground(Pixel p)
{
    XtVaSetValues(widget(), XmNbuttonLabelBackground, p, NULL);
}

Pixel MatrixClass::buttonLabelBackground() const
{
    Pixel p;

    XtVaGetValues(widget(), XmNbuttonLabelBackground, &p, NULL);

    return p;
}

void MatrixClass::cellBackgrounds(PixelTable pt)
{
    XtVaSetValues(widget(), XmNcellBackgrounds, pt, NULL);
}

PixelTable MatrixClass::cellBackgrounds() const
{
    PixelTable pt;

    XtVaGetValues(widget(), XmNcellBackgrounds, &pt, NULL);

    return pt;
}

void MatrixClass::cellHighlightThickness(Dimension d)
{
    XtVaSetValues(widget(), XmNcellHighlightThickness, d, NULL);
}

Dimension MatrixClass::cellHighlightThickness() const
{
    Dimension d;

    XtVaGetValues(widget(), XmNcellHighlightThickness, &d, NULL);

    return d;
}

void MatrixClass::cellMarginHeight(Dimension d)
{
    XtVaSetValues(widget(), XmNcellMarginHeight, d, NULL);
}

Dimension MatrixClass::cellMarginHeight() const
{
    Dimension d;

    XtVaGetValues(widget(), XmNcellMarginHeight, &d, NULL);

    return d;
}

void MatrixClass::cellMarginWidth(Dimension d)
{
    XtVaSetValues(widget(), XmNcellMarginWidth, d, NULL);
}

Dimension MatrixClass::cellMarginWidth() const
{
    Dimension d;

    XtVaGetValues(widget(), XmNcellMarginWidth, &d, NULL);

    return d;
}

void MatrixClass::cellShadowThickness(Dimension d)
{
    XtVaSetValues(widget(), XmNcellShadowThickness, d, NULL);
}

Dimension MatrixClass::cellShadowThickness() const
{
    Dimension d;

    XtVaGetValues(widget(), XmNcellShadowThickness, &d, NULL);

    return d;
}

void MatrixClass::cellShadowType(unsigned char ch)
{
    XtVaSetValues(widget(), XmNcellShadowType, ch, NULL);
}

unsigned char MatrixClass::cellShadowType() const
{
    unsigned char ch;

    XtVaGetValues(widget(), XmNcellShadowType, &ch, NULL);

    return ch;
}

void MatrixClass::cellShadowTypes(unsigned char **cpp)
{
    XtVaSetValues(widget(), XmNcellShadowTypes, cpp, NULL);
}

unsigned char **MatrixClass::cellShadowTypes() const
{
    unsigned char **cpp;

    XtVaGetValues(widget(), XmNcellShadowTypes, &cpp, NULL);

    return cpp;
}

void MatrixClass::cellUserData(XtPointer **xpp)
{
    XtVaSetValues(widget(), XmNcellUserData, xpp, NULL);
}

XtPointer **MatrixClass::cellUserData() const
{
    XtPointer **xpp;

    XtVaGetValues(widget(), XmNcellUserData, &xpp, NULL);

    return xpp;
}

Widget MatrixClass::clipWindow() const
{
    Widget w;

    XtVaGetValues(widget(), XmNclipWindow, &w, NULL);

    return w;
}

void MatrixClass::cells(CellTable ct)
{
    XtVaSetValues(widget(), XmNcells, ct, NULL);
}

CellTable MatrixClass::cells() const
{
    CellTable ct;

    XtVaGetValues(widget(), XmNcells, &ct, NULL);

    return ct;
}

void MatrixClass::colors(PixelTable pt)
{
    XtVaSetValues(widget(), XmNcolors, pt, NULL);
}

PixelTable MatrixClass::colors() const
{
    PixelTable pt;

    XtVaGetValues(widget(), XmNcolors, &pt, NULL);

    return pt;
}

void MatrixClass::columnAlignments(AlignmentArray aa)
{
    XtVaSetValues(widget(), XmNcolumnAlignments, aa, NULL);
}

AlignmentArray MatrixClass::columnAlignments() const
{
    AlignmentArray aa;

    XtVaGetValues(widget(), XmNcolumnAlignments, &aa, NULL);

    return aa;
}

void MatrixClass::columnButtonLabels(BooleanArray ba)
{
    XtVaSetValues(widget(), XmNcolumnButtonLabels, ba, NULL);
}

BooleanArray MatrixClass::columnButtonLabels() const
{
    BooleanArray ba;

    XtVaGetValues(widget(), XmNcolumnButtonLabels, &ba, NULL);

    return ba;
}

void MatrixClass::columnLabelAlignments(AlignmentArray aa)
{
    XtVaSetValues(widget(), XmNcolumnLabelAlignments, aa, NULL);
}

AlignmentArray MatrixClass::columnLabelAlignments() const
{
    AlignmentArray aa;

    XtVaGetValues(widget(), XmNcolumnLabelAlignments, &aa, NULL);

    return aa;
}

void MatrixClass::columnLabelColor(Pixel p)
{
    XtVaSetValues(widget(), XmNcolumnLabelColor, p, NULL);
}

Pixel MatrixClass::columnLabelColor() const
{
    Pixel p;

    XtVaGetValues(widget(), XmNcolumnLabelColor, &p, NULL);

    return p;
}

void MatrixClass::columnLabels(StringArray sa)
{
    XtVaSetValues(widget(), XmNcolumnLabels, sa, NULL);
}

StringArray MatrixClass::columnLabels() const
{
    StringArray sa;

    XtVaGetValues(widget(), XmNcolumnLabels, &sa, NULL);

    return sa;
}

void MatrixClass::columnMaxLengths(MaxLengthArray mla)
{
    XtVaSetValues(widget(), XmNcolumnMaxLengths, mla, NULL);
}

MaxLengthArray MatrixClass::columnMaxLengths() const
{
    MaxLengthArray mla;

    XtVaGetValues(widget(), XmNcolumnMaxLengths, &mla, NULL);

    return mla;
}

void MatrixClass::columnShadowTypes(unsigned char *cp)
{
    XtVaSetValues(widget(), XmNcolumnShadowTypes, cp, NULL);
}

unsigned char *MatrixClass::columnShadowTypes() const
{
    unsigned char *cp;

    XtVaGetValues(widget(), XmNcolumnShadowTypes, &cp, NULL);

    return cp;
}

void MatrixClass::columnUserData(XtPointer *xp)
{
    XtVaSetValues(widget(), XmNcolumnUserData, xp, NULL);
}

XtPointer *MatrixClass::columnUserData() const
{
    XtPointer *xp;

    XtVaGetValues(widget(), XmNcolumnUserData, &xp, NULL);

    return xp;
}

void MatrixClass::columnWidths(WidthArray wa)
{
    XtVaSetValues(widget(), XmNcolumnWidths, wa, NULL);
}

WidthArray MatrixClass::columnWidths() const
{
    WidthArray wa;

    XtVaGetValues(widget(), XmNcolumnWidths, &wa, NULL);

    return wa;
}

void MatrixClass::columns(int i)
{
    XtVaSetValues(widget(), XmNcolumns, i, NULL);
}

int MatrixClass::columns() const
{
    int i;

    XtVaGetValues(widget(), XmNcolumns, &i, NULL);

    return i;
}

void MatrixClass::doubleClickInterval(int i)
{
    XtVaSetValues(widget(), XmNdoubleClickInterval, i, NULL);
}

int MatrixClass::doubleClickInterval() const
{
    int i;

    XtVaGetValues(widget(), XmNdoubleClickInterval, &i, NULL);

    return i;
}

void MatrixClass::evenRowBackground(Pixel p)
{
    XtVaSetValues(widget(), XmNevenRowBackground, p, NULL);
}

Pixel MatrixClass::evenRowBackground() const
{
    Pixel p;

    XtVaGetValues(widget(), XmNevenRowBackground, &p, NULL);

    return p;
}

void MatrixClass::fill(Boolean b)
{
    XtVaSetValues(widget(), XmNfill, b, NULL);
}

Boolean MatrixClass::fill() const
{
    Boolean b;

    XtVaGetValues(widget(), XmNfill, &b, NULL);

    return b;
}

void MatrixClass::fixedColumns(Dimension d)
{
    XtVaSetValues(widget(), XmNfixedColumns, d, NULL);
}

Dimension MatrixClass::fixedColumns() const
{
    Dimension d;

    XtVaGetValues(widget(), XmNfixedColumns, &d, NULL);

    return d;
}

void MatrixClass::fixedRows(Dimension d)
{
    XtVaSetValues(widget(), XmNfixedRows, d, NULL);
}

Dimension MatrixClass::fixedRows() const
{
    Dimension d;

    XtVaGetValues(widget(), XmNfixedRows, &d, NULL);

    return d;
}

void MatrixClass::fontList(XmFontList fl)
{
    XtVaSetValues(widget(), XmNfontList, fl, NULL);
}

XmFontList MatrixClass::fontList() const
{
    XmFontList fl;

    XtVaGetValues(widget(), XmNfontList, &fl, NULL);

    return fl;
}

void MatrixClass::gridLineColor(Pixel p)
{
    XtVaSetValues(widget(), XmNgridLineColor, p, NULL);
}

Pixel MatrixClass::gridLineColor() const
{
    Pixel p;

    XtVaGetValues(widget(), XmNgridLineColor, &p, NULL);

    return p;
}

void MatrixClass::gridType(GridType gt)
{
    XtVaSetValues(widget(), XmNgridType, gt, NULL);
}

GridType MatrixClass::gridType() const
{
    GridType gt;

    XtVaGetValues(widget(), XmNgridType, &gt, NULL);

    return gt;
}

void MatrixClass::highlightedCells(HighlightTable ht)
{
    XtVaSetValues(widget(), XmNhighlightedCells, ht, NULL);
}

HighlightTable MatrixClass::highlightedCells() const
{
    HighlightTable ht;

    XtVaGetValues(widget(), XmNhighlightedCells, &ht, NULL);

    return ht;
}

Widget MatrixClass::horizontalScrollBar() const
{
    Widget w;

    XtVaGetValues(widget(), XmNhorizontalScrollBar, &w, NULL);

    return w;
}

void MatrixClass::horizontalScrollBarDisplayPolicy(unsigned char ch)
{
    XtVaSetValues(widget(), XmNhorizontalScrollBarDisplayPolicy, ch, NULL);
}

unsigned char MatrixClass::horizontalScrollBarDisplayPolicy() const
{
    unsigned char ch;

    XtVaGetValues(widget(), XmNhorizontalScrollBarDisplayPolicy, &ch, NULL);

    return ch;
}

void MatrixClass::labelFont(const XmFontList fl)
{
    XtVaSetValues(widget(), XmNlabelFont, fl, NULL);
}

XmFontList MatrixClass::labelFont() const
{
    XmFontList fl;

    XtVaGetValues(widget(), XmNlabelFont, &fl, NULL);

    return fl;
}

void MatrixClass::leftColumn(int i)
{
    XtVaSetValues(widget(), XmNleftColumn, i, NULL);
}

int MatrixClass::leftColumn() const
{
    int i;

    XtVaGetValues(widget(), XmNleftColumn, &i, NULL);

    return i;
}

void MatrixClass::oddRowBackground(Pixel p)
{
    XtVaSetValues(widget(), XmNoddRowBackground, p, NULL);
}

Pixel MatrixClass::oddRowBackground() const
{
    Pixel p;

    XtVaGetValues(widget(), XmNoddRowBackground, &p, NULL);

    return p;
}

void MatrixClass::reverseSelect(Boolean b)
{
    XtVaSetValues(widget(), XmNreverseSelect, b, NULL);
}

Boolean MatrixClass::reverseSelect() const
{
    Boolean b;

    XtVaGetValues(widget(), XmNreverseSelect, &b, NULL);

    return b;
}

void MatrixClass::rowButtonLabels(BooleanArray ba)
{
    XtVaSetValues(widget(), XmNrowButtonLabels, ba, NULL);
}

BooleanArray MatrixClass::rowButtonLabels() const
{
    BooleanArray ba;

    XtVaGetValues(widget(), XmNrowButtonLabels, &ba, NULL);

    return ba;
}

void MatrixClass::rowLabelAlignment(Alignment al)
{
    XtVaSetValues(widget(), XmNrowLabelAlignment, al, NULL);
}

Alignment MatrixClass::rowLabelAlignment() const
{
    Alignment al;

    XtVaGetValues(widget(), XmNrowLabelAlignment, &al, NULL);

    return al;
}

void MatrixClass::rowLabelColor(Pixel p)
{
    XtVaSetValues(widget(), XmNrowLabelColor, p, NULL);
}

Pixel MatrixClass::rowLabelColor() const
{
    Pixel p;

    XtVaGetValues(widget(), XmNrowLabelColor, &p, NULL);

    return p;
}

void MatrixClass::rowLabelWidth(short sh)
{
    XtVaSetValues(widget(), XmNrowLabelWidth, sh, NULL);
}

short MatrixClass::rowLabelWidth() const
{
    short sh;

    XtVaGetValues(widget(), XmNrowLabelWidth, &sh, NULL);

    return sh;
}

void MatrixClass::rowLabels(StringArray sa)
{
    XtVaSetValues(widget(), XmNrowLabels, sa, NULL);
}

StringArray MatrixClass::rowLabels() const
{
    StringArray sa;

    XtVaGetValues(widget(), XmNrowLabels, &sa, NULL);

    return sa;
}

void MatrixClass::rowShadowTypes(unsigned char *cp)
{
    XtVaSetValues(widget(), XmNrowShadowTypes, cp, NULL);
}

unsigned char *MatrixClass::rowShadowTypes() const
{
    unsigned char *cp;

    XtVaGetValues(widget(), XmNrowShadowTypes, &cp, NULL);

    return cp;
}

void MatrixClass::rowUserData(XtPointer *xp)
{
    XtVaSetValues(widget(), XmNrowUserData, xp, NULL);
}

XtPointer *MatrixClass::rowUserData() const
{
    XtPointer *xp;

    XtVaGetValues(widget(), XmNrowUserData, &xp, NULL);

    return xp;
}

void MatrixClass::rows(int i)
{
    XtVaSetValues(widget(), XmNrows, i, NULL);
}

int MatrixClass::rows() const
{
    int i;

    XtVaGetValues(widget(), XmNrows, &i, NULL);

    return i;
}

void MatrixClass::scrollBarPlacement(unsigned char uc)
{
    XtVaSetValues(widget(), XmNscrollBarPlacement, uc, NULL);
}

unsigned char MatrixClass::scrollBarPlacement() const
{
    unsigned char uc;

    XtVaGetValues(widget(), XmNscrollBarPlacement, &uc, NULL);

    return uc;
}

void MatrixClass::selectScrollVisible(Boolean b)
{
    XtVaSetValues(widget(), XmNselectScrollVisible, b, NULL);
}

Boolean MatrixClass::selectScrollVisible() const
{
    Boolean b;

   XtVaGetValues(widget(), XmNselectScrollVisible, &b, NULL);

    return b;
}

void MatrixClass::selectedBackground(Pixel p)
{
    XtVaSetValues(widget(), XmNselectedBackground, p, NULL);
}

Pixel MatrixClass::selectedBackground() const
{
    Pixel p;

    XtVaGetValues(widget(), XmNselectedBackground, &p, NULL);

    return p;
}

void MatrixClass::selectedCells(BooleanTable bt)
{
    XtVaSetValues(widget(), XmNselectedCells, bt, NULL);
}

BooleanTable MatrixClass::selectedCells() const
{
    BooleanTable bt;

    XtVaGetValues(widget(), XmNselectedCells, &bt, NULL);

    return bt;
}

void MatrixClass::selectedForeground(Pixel p)
{
    XtVaSetValues(widget(), XmNselectedForeground, p, NULL);
}

Pixel MatrixClass::selectedForeground() const
{
    Pixel p;

    XtVaGetValues(widget(), XmNselectedForeground, &p, NULL);

    return p;
}

void MatrixClass::shadowType(unsigned char uc)
{
    XtVaSetValues(widget(), XmNshadowType, uc, NULL);
}

unsigned char MatrixClass::shadowType() const
{
    unsigned char uc;

    XtVaGetValues(widget(), XmNshadowType, &uc, NULL);

    return uc;
}

void MatrixClass::showArrows(Boolean b)
{
    XtVaSetValues(widget(), XmNshowArrows, b, NULL);
}

Boolean MatrixClass::showArrows() const
{
    Boolean b;

    XtVaGetValues(widget(), XmNshowArrows, &b, NULL);

    return b;
}

void MatrixClass::space(Dimension d)
{
    XtVaSetValues(widget(), XmNspace, d, NULL);
}

Dimension MatrixClass::space() const
{
    Dimension d;

    XtVaGetValues(widget(), XmNspace, &d, NULL);

    return d;
}

void MatrixClass::textBackground(Pixel p)
{
    XtVaSetValues(widget(), XmNtextBackground, p, NULL);
}

Pixel MatrixClass::textBackground() const
{
    Pixel p;

    XtVaGetValues(widget(), XmNtextBackground, &p, NULL);

    return p;
}

Widget MatrixClass::textField() const
{
    Widget w;

    XtVaGetValues(widget(), XmNtextField, &w, NULL);

    return w;
}

void MatrixClass::textShadowThickness(Dimension d)
{
    XtVaSetValues(widget(), XmNtextShadowThickness, d, NULL);
}

Dimension MatrixClass::textShadowThickness() const
{
    Dimension d;

    XtVaGetValues(widget(), XmNtextShadowThickness, &d, NULL);

    return d;
}

void MatrixClass::textTranslations(TranslationTable tt)
{
    XtVaSetValues(widget(), XmNtextTranslations, tt, NULL);
}

TranslationTable MatrixClass::textTranslations() const
{
    TranslationTable tt;

    XtVaGetValues(widget(), XmNtextTranslations, &tt, NULL);

    return tt;
}

void MatrixClass::topRow(int i)
{
    XtVaSetValues(widget(), XmNtopRow, i, NULL);
}

int MatrixClass::topRow() const
{
    int i;

    XtVaGetValues(widget(), XmNtopRow, &i, NULL);

    return i;
}

void MatrixClass::trailingFixedColumns(Dimension d)
{
    XtVaSetValues(widget(), XmNtrailingFixedColumns, d, NULL);
}

Dimension MatrixClass::trailingFixedColumns() const
{
    Dimension d;

    XtVaGetValues(widget(), XmNtrailingFixedColumns, &d, NULL);

    return d;
}

void MatrixClass::trailingFixedRows(Dimension d)
{
    XtVaSetValues(widget(), XmNtrailingFixedRows, d, NULL);
}

Dimension MatrixClass::trailingFixedRows() const
{
    Dimension d;

    XtVaGetValues(widget(), XmNtrailingFixedRows, &d, NULL);

    return d;
}

void MatrixClass::traverseFixedCells(Boolean b)
{
    XtVaSetValues(widget(), XmNtraverseFixedCells, b, NULL);
}

Boolean MatrixClass::traverseFixedCells() const
{
    Boolean b;

    XtVaGetValues(widget(), XmNtraverseFixedCells, &b, NULL);

    return b;
}

Widget MatrixClass::verticalScrollBar() const
{
    Widget w;

    XtVaGetValues(widget(), XmNverticalScrollBar, &w, NULL);

    return w;
}

void MatrixClass::verticalScrollBarDisplayPolicy(unsigned char uc)
{
    XtVaSetValues(widget(), XmNverticalScrollBarDisplayPolicy, uc, NULL);
}

unsigned char MatrixClass::verticalScrollBarDisplayPolicy() const
{
    unsigned char uc;

    XtVaGetValues(widget(), XmNverticalScrollBarDisplayPolicy, &uc, NULL);

    return uc;
}

void MatrixClass::visibleColumns(Dimension d)
{
    XtVaSetValues(widget(), XmNvisibleColumns, d, NULL);
}

Dimension MatrixClass::visibleColumns() const
{
    Dimension d;

    XtVaGetValues(widget(), XmNvisibleColumns, &d, NULL);

    return d;
}

void MatrixClass::visibleRows(Dimension d)
{
    XtVaSetValues(widget(), XmNvisibleRows, d, NULL);
}

Dimension MatrixClass::visibleRows() const
{
    Dimension d;

    XtVaGetValues(widget(), XmNvisibleRows, &d, NULL);

    return d;
}

Matrix::Matrix(Widget w_parent, ArgList arglist, Cardinal cnt,  _XtString name)
{
    Widget wid = createWidget(name, w_parent, arglist, cnt);
    widget(wid);
    manage();
}

Matrix::Matrix(_XtString name, Widget w_parent)
{
    Widget wid = createWidget(name, w_parent);
    widget(wid);
    manage();
}

Matrix::Matrix(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(wid);
   widget(wid);
   manage();
}


#endif // XARM_HAS_XBAE
