/* $Id: ToggleBG.C,v 1.4 1999/02/03 13:50:23 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/ToggleBG.h>
/* ToggleButtonGadgetClass Members */
/* callbacks */
void
ToggleButtonGadgetClass::armCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNarmCallback,funcp,data);
}

void
ToggleButtonGadgetClass::disarmCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNdisarmCallback,funcp,data);
}

void
ToggleButtonGadgetClass::valueChangedCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNvalueChangedCallback,funcp,data);
}

/* convenience routines */
Boolean 
ToggleButtonGadgetClass::getState() const
{
   return XmToggleButtonGetState(widget());
}

void 
ToggleButtonGadgetClass::setState(Boolean state, Boolean notify)
{
   XmToggleButtonSetState(widget(), state, notify);
}

/* resources */
void
ToggleButtonGadgetClass::fillOnSelect(Boolean b)
{
   XtVaSetValues(widget(), XmNfillOnSelect, b, NULL);
}

Boolean
ToggleButtonGadgetClass::fillOnSelect() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNfillOnSelect, &b, NULL);
   return b;
}

void
ToggleButtonGadgetClass::indicatorOn(Boolean b)
{
   XtVaSetValues(widget(), XmNindicatorOn, b, NULL);
}

Boolean
ToggleButtonGadgetClass::indicatorOn() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNindicatorOn, &b, NULL);
   return b;
}

void
ToggleButtonGadgetClass::indicatorSize(Dimension d)
{
   XtVaSetValues(widget(), XmNindicatorSize, d, NULL);
}

Dimension
ToggleButtonGadgetClass::indicatorSize() const
{
   Dimension d;
   XtVaGetValues(widget(), XmNindicatorSize, &d, NULL);
   return d;
}

void
ToggleButtonGadgetClass::indicatorType(unsigned char c)
{
   XtVaSetValues(widget(), XmNindicatorType, c, NULL);
}

unsigned char
ToggleButtonGadgetClass::indicatorType() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNindicatorType, &c, NULL);
   return c;
}

void
ToggleButtonGadgetClass::selectColor(Pixel p)
{
   XtVaSetValues(widget(), XmNselectColor, p, NULL);
}

Pixel
ToggleButtonGadgetClass::selectColor() const
{
   Pixel p;
   XtVaGetValues(widget(), XmNselectColor, &p, NULL);
   return p;
}

void
ToggleButtonGadgetClass::selectInsensitivePixmap(Pixmap p)
{
   XtVaSetValues(widget(), XmNselectInsensitivePixmap, p, NULL);
}

Pixmap
ToggleButtonGadgetClass::selectInsensitivePixmap() const
{
   Pixmap p;
   XtVaGetValues(widget(), XmNselectInsensitivePixmap, &p, NULL);
   return p;
}

void
ToggleButtonGadgetClass::set(Boolean b)
{
   XtVaSetValues(widget(), XmNset, b, NULL);
}

Boolean
ToggleButtonGadgetClass::set() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNset, &b, NULL);
   return b;
}

void
ToggleButtonGadgetClass::spacing(Dimension d)
{
   XtVaSetValues(widget(), XmNspacing, d, NULL);
}

Dimension
ToggleButtonGadgetClass::spacing() const
{
   Dimension d;
   XtVaGetValues(widget(), XmNspacing, &d, NULL);
   return d;
}

void
ToggleButtonGadgetClass::visibleWhenOff(Boolean b)
{
   XtVaSetValues(widget(), XmNvisibleWhenOff, b, NULL);
}

Boolean 
ToggleButtonGadgetClass::visibleWhenOff() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNvisibleWhenOff, &b, NULL);
   return b;
}

/* constructors */
ToggleButtonGadget::ToggleButtonGadget(Widget w_parent, char *str, KeySym mn,
                                       _XtString acc, char *accText, _XtString name) 
{
/*
   Widget w = XtVaCreateWidget("XmToggleButtonGadget",
                               xmToggleButtonGadgetClass,
                               w_parent,
                               NULL);
*/
   Widget w = createWidget(name, w_parent);
   widget(w);
   labelString(str);
   manage();

   alignment(XmALIGNMENT_BEGINNING);
   if(mn != 0) mnemonic(mn);
   if(acc) accelerator(acc);
   if(accText) acceleratorText(accText);
}

ToggleButtonGadget::ToggleButtonGadget(Widget w_parent, 
                                       ArgList arglist, 
                                       Cardinal cnt,
                                       _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt);
   widget(w);
   manage();
}

ToggleButtonGadget::ToggleButtonGadget(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
   manage();
}

ToggleButtonGadget::ToggleButtonGadget(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   manage();
}
