/*
 Copyright (C) 1997 Gerald L. Gay

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#include <Xarm/SpinBox.h>

/*
* The SpinBox only exists in versions of Motif >= 2 and CDE.
* However, you could write one yourself and remove this restriction.
*/
#if XmVERSION >= 2

/* callbacks */
void
SpinBoxClass::modifyVerifyCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNmodifyVerifyCallback,fp,udata);
}

void
SpinBoxClass::valueChangedCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNvalueChangedCallback,fp,udata);
}

/* resources */

void SpinBoxClass::arrowSize(Dimension d)
{
   XtVaSetValues(widget(),XmNarrowSize,d,NULL);
}

Dimension SpinBoxClass::arrowSize() const
{
   Dimension d;
   XtVaGetValues(widget(),XmNarrowSize, &d,NULL);
   return d;
}

void SpinBoxClass::detailShadowThickness(Dimension d)
{
   XtVaSetValues(widget(),XmNdetailShadowThickness,d,NULL);
}

Dimension SpinBoxClass::detailShadowThickness() const
{
   Dimension d;
   XtVaGetValues(widget(),XmNdetailShadowThickness, &d,NULL);
   return d;
}

void SpinBoxClass::marginWidth(Dimension d)
{
   XtVaSetValues(widget(),XmNmarginWidth,d,NULL);
}

Dimension SpinBoxClass::marginWidth() const
{
   Dimension d;
   XtVaGetValues(widget(),XmNmarginWidth, &d,NULL);
   return d;
}

void SpinBoxClass::spacing(Dimension d)
{
   XtVaSetValues(widget(),XmNspacing,d,NULL);
}

Dimension SpinBoxClass::spacing() const
{
   Dimension d;
   XtVaGetValues(widget(),XmNspacing, &d,NULL);
   return d;
}

void SpinBoxClass::arrowLayout(unsigned char c)
{
    XtVaSetValues(widget(), XmNarrowLayout, c, NULL);
}

unsigned char SpinBoxClass::arrowLayout() const
{
    unsigned char c;

    XtVaGetValues(widget(), XmNarrowLayout, &c, NULL);
    return c;
}

void SpinBoxClass::defaultArrowSensitivity(unsigned char c)
{
    XtVaSetValues(widget(), XmNdefaultArrowSensitivity, c, NULL);
}

unsigned char SpinBoxClass::defaultArrowSensitivity() const
{
    unsigned char c;

    XtVaGetValues(widget(), XmNdefaultArrowSensitivity, &c, NULL);
    return c;
}

void SpinBoxClass::arrowSensitivity(unsigned char c)
{
    XtVaSetValues(widget(), XmNarrowSensitivity, c, NULL);
}

unsigned char SpinBoxClass::arrowSensitivity() const
{
    unsigned char c;

    XtVaGetValues(widget(), XmNarrowSensitivity, &c, NULL);
    return c;
}

unsigned char SpinBoxClass::spinBoxChildType(Widget w) const
{
    unsigned char c;

    XtVaGetValues(w, XmNspinBoxChildType, &c, NULL);
    return c;
}

void SpinBoxClass::decimalPoints(Widget w, short s)
{
    XtVaSetValues(w, XmNdecimalPoints, s, NULL);
}

short SpinBoxClass::decimalPoints(Widget w) const
{
    short s;

    XtVaGetValues(w, XmNdecimalPoints, &s, NULL);
    return s;
}

void SpinBoxClass::initialDelay(unsigned int u)
{
    XtVaSetValues(widget(), XmNinitialDelay, u, NULL);
}

unsigned int SpinBoxClass::initialDelay() const
{
    unsigned int u;

    XtVaGetValues(widget(), XmNinitialDelay, &u, NULL);
    return u;
}

void SpinBoxClass::repeatDelay(unsigned int u)
{
    XtVaSetValues(widget(), XmNrepeatDelay, u, NULL);
}

unsigned int SpinBoxClass::repeatDelay() const
{
    unsigned int u;

    XtVaGetValues(widget(), XmNrepeatDelay, &u, NULL);
    return u;
}

void SpinBoxClass::incrementValue(Widget w, int i)
{
    XtVaSetValues(w, XmNincrementValue, i, NULL);
}

int SpinBoxClass::incrementValue(Widget w) const
{
    int i;

    XtVaGetValues(w, XmNincrementValue, &i, NULL);
    return i;
}

void SpinBoxClass::maximumValue(Widget w, int i)
{
    XtVaSetValues(widget(), XmNmaximumValue, i, NULL);
}

int SpinBoxClass::maximumValue(Widget w) const
{
    int i;

    XtVaGetValues(w, XmNmaximumValue, &i, NULL);
    return i;
}

void SpinBoxClass::minimumValue(Widget w, int i)
{
    XtVaSetValues(w, XmNminimumValue, i, NULL);
}

int SpinBoxClass::minimumValue(Widget w) const
{
    int i;

    XtVaGetValues(w, XmNminimumValue, &i, NULL);
    return i;
}

void SpinBoxClass::numValues(Widget w, int i)
{
    XtVaSetValues(w, XmNnumValues, i, NULL);
}

int SpinBoxClass::numValues(Widget w) const
{
    int i;

    XtVaGetValues(w, XmNnumValues, &i, NULL);
    return i;
}

void SpinBoxClass::position(Widget w, int i)
{
    XtVaSetValues(w, XmNposition, i, NULL);
}

int SpinBoxClass::position(Widget w) const
{
    int i;

    XtVaGetValues(w, XmNposition, &i, NULL);
    return i;
}

void SpinBoxClass::values(Widget w, const XmStringTable s)
{
    XtVaSetValues(w, XmNvalues, s, NULL);
}

XmStringTable SpinBoxClass::values(Widget w) const
{
    XmStringTable s;

    XtVaGetValues(w, XmNvalues, &s, NULL);
    return s;
}

void SpinBoxClass::values(Widget w, const char **l, const int c)
{
    int i;
    XmString *xmstr = new XmString [c];

    if (xmstr == NULL) return;

    for (i = 0; i < c; i++) {
        xmstr[i] = cvtStringToXmString(l[i]);
    }
 
    values(w, (XmStringTable)xmstr);
    numValues(w, c);

    for (i = 0; i < c; i++) {
        XmStringFree(xmstr[i]);
    }
    delete [] xmstr;
}


Widget
SpinBoxClass::createWidget(_XtString name,
                       Widget w_parent,
                       ArgList arglist,
                       Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreateSpinBox(w_parent, name, arglist, cnt);
}

SpinBox::SpinBox(Widget w_parent,
            ArgList arglist, 
            Cardinal cnt,
            _XtString name)
{
   Widget w = createWidget(name, w_parent,arglist,cnt);
   widget(w);
}

SpinBox::SpinBox(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
}

SpinBox::SpinBox(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
}

#endif
