/* $Id: Scale.C,v 1.4 1999/02/03 13:50:23 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/Scale.h>

/* ScaleClass Members */
/* callbacks */
void
ScaleClass::dragCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNdragCallback,funcp,data);
}

void
ScaleClass::valueChangedCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNvalueChangedCallback,funcp,data);
}

/* resources */
void
ScaleClass::decimalPoints(short s)
{
   XtVaSetValues(widget(), XmNdecimalPoints, s, NULL);
}

short
ScaleClass::decimalPoints() const
{
   short s;
   XtVaGetValues(widget(), XmNdecimalPoints, &s, NULL);
   return s;
}

void
ScaleClass::fontList(const XmFontList fl)
{
   XtVaSetValues(widget(), XmNfontList, fl, NULL);
}

XmFontList
ScaleClass::fontList() const
{
   XmFontList fl;
   XtVaGetValues(widget(), XmNfontList, &fl, NULL);
   return fl;
}

void
ScaleClass::highlightOnEnter(Boolean b)
{
   XtVaSetValues(widget(), XmNhighlightOnEnter, b, NULL);
}

Boolean
ScaleClass::highlightOnEnter() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNhighlightOnEnter, &b, NULL);
   return b;
}

void
ScaleClass::highlightThickness(Dimension d)
{
   XtVaSetValues(widget(), XmNhighlightThickness, d, NULL);
}

Dimension
ScaleClass::highlightThickness() const
{
   Dimension d;
   XtVaGetValues(widget(), XmNhighlightThickness, &d, NULL);
   return d;
}

void
ScaleClass::maximum(int max)
{
   XtVaSetValues(widget(), XmNmaximum, max, NULL);
}

int
ScaleClass::maximum() const
{
   int max;
   XtVaGetValues(widget(), XmNmaximum, &max, NULL);
   return max;
}

void
ScaleClass::minimum(int min)
{
   XtVaSetValues(widget(), XmNminimum, min, NULL);
}

int
ScaleClass::minimum() const
{
   int min;
   XtVaGetValues(widget(), XmNminimum, &min, NULL);
   return min;
}

void
ScaleClass::orientation(unsigned char orient)
{
   XtVaSetValues(widget(), XmNorientation, orient, NULL);
}

unsigned char
ScaleClass::orientation() const
{
   unsigned char orient;
   XtVaGetValues(widget(), XmNorientation, &orient, NULL);
   return orient;
}

void 
ScaleClass::processingDirection(unsigned char d)
{
   XtVaSetValues(widget(), XmNprocessingDirection, d, NULL);
}

unsigned char 
ScaleClass::processingDirection() const
{
   unsigned char d;
   XtVaGetValues(widget(), XmNprocessingDirection, &d, NULL);
   return d;
}

void
ScaleClass::scaleHeight(Dimension h)
{
   XtVaSetValues(widget(), XmNscaleHeight, h, NULL);
}

Dimension
ScaleClass::scaleHeight() const
{
   Dimension d;
   XtVaGetValues(widget(), XmNscaleHeight, &d, NULL);
   return d;
}

void
ScaleClass::scaleMultiple(int m)
{
   XtVaSetValues(widget(), XmNscaleMultiple, m, NULL);
}

int
ScaleClass::scaleMultiple() const
{
   int i;
   XtVaGetValues(widget(), XmNscaleMultiple, &i, NULL);
   return i;
}

void
ScaleClass::scaleWidth(Dimension w)
{
   XtVaSetValues(widget(), XmNscaleWidth, w, NULL);
}

Dimension
ScaleClass::scaleWidth() const
{
   Dimension d;
   XtVaGetValues(widget(), XmNscaleWidth, &d, NULL);
   return d;
}

void
ScaleClass::showValue(Boolean val)
{
   XtVaSetValues(widget(), XmNshowValue, val, NULL);
}

Boolean
ScaleClass::showValue() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNshowValue, &b, NULL);
   return b;
}

void
ScaleClass::titleString(const char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNtitleString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
ScaleClass::titleString() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNtitleString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
ScaleClass::value(int val)
{
   XtVaSetValues(widget(), XmNvalue, val, NULL);
}

int
ScaleClass::value() const
{
   int val;
   XtVaGetValues(widget(), XmNvalue, &val, NULL);
   return val;
}

Scale::Scale(Widget w_parent, ArgList arglist, Cardinal cnt, _XtString name)
{
   Widget wid = createWidget(name, w_parent, arglist, cnt);
   widget(wid);
}

Scale::Scale(Widget w_parent, XarmArg &args,  _XtString name)
{
   Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(wid);
   widget(wid);
}

Scale::Scale(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name, w_parent);
   widget(wid);
}

