/* $Id: Property.C,v 1.4 1999/02/03 13:50:23 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/Property.h>

/* PropertySheetClass members */
Widget
PropertySheetClass::getChild(unsigned char ch) const
{
   return XmPropertySheetGetChild(widget(), ch);
}

int
PropertySheetClass::pageCount() const
{
   int cnt;
   XtVaGetValues(widget(), XmNpageCount, &cnt, NULL);
   return cnt;
}

Widget 
PropertySheetClass::getPage(int pos) const
{
   return XmPropertySheetGetPage(widget(), pos);
}

void
PropertySheetClass::addPage(Widget w, int pos)
{
   XmPropertySheetAddPage(widget(), w, pos);
}

void
PropertySheetClass::removePage(Widget w)
{
   XmPropertySheetRemovePage(widget(), w);
}

void
PropertySheetClass::removePage(int pos)
{
   XmPropertySheetRemovePos(widget(), pos);
}

void
PropertySheetClass::cancelLabelString(const char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNcancelLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
PropertySheetClass::cancelLabelString() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNcancelLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
PropertySheetClass::applyLabelString(const char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNapplyLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
PropertySheetClass::applyLabelString() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNapplyLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
PropertySheetClass::helpLabelString(const char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNhelpLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
PropertySheetClass::helpLabelString() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNhelpLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
PropertySheetClass::okLabelString(const char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNokLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
PropertySheetClass::okLabelString() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNokLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
PropertySheetClass::cancelCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNcancelCallback,funcp,data);
}

void
PropertySheetClass::okCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNokCallback,funcp,data);
}

void
PropertySheetClass::applyCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNapplyCallback,funcp,data);
}


Widget
PropertySheetClass::createWidget(_XtString name,
                       Widget w_parent,
                       ArgList arglist,
                       Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreatePropertySheet(w_parent, name, arglist, cnt);
}

PropertySheet::PropertySheet(Widget w_parent, ArgList arglist, Cardinal cnt,
                             _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt);
   widget(w);
}

PropertySheet::PropertySheet(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
}

PropertySheet::PropertySheet(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
}

Widget
PropertySheetDialog::createWidget(_XtString name,
                       Widget w_parent,
                       ArgList arglist,
                       Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreatePropertySheetDialog(w_parent, name, arglist, cnt);
}

PropertySheetDialog::PropertySheetDialog(Widget w_parent, 
                                         ArgList arglist, 
                                         Cardinal cnt,
                                         _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt);
   widget(w);
}

PropertySheetDialog::PropertySheetDialog(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
}

PropertySheetDialog::PropertySheetDialog(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
}

