/* $Id: MenuBar.C,v 1.3 1998/07/24 18:53:25 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/RowColumn.h>

/* MenuBarClass member functions */
void
MenuBarClass::help(Widget button)
{
   if(button)
      XtVaSetValues(widget(),XmNmenuHelpWidget,button, NULL);
}

Widget
MenuBar::createWidget(_XtString name, Widget w_parent, ArgList arglist, Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreateMenuBar(w_parent, name, arglist, cnt);
}

MenuBar::MenuBar(Widget w_parent, ArgList arglist, Cardinal cnt, _XtString name)
{
   Widget wid = createWidget(name, w_parent, arglist, cnt);
   widget(wid);
}

MenuBar::MenuBar(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(wid);
   widget(wid);
}

MenuBar::MenuBar(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name, w_parent);
   widget(wid);
}


