/* $Id: Gauge.C,v 1.2 1999/01/15 10:16:40 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/Gauge.h>
/* Gauge Members */

void GaugeClass::gaugeMargin(int m)
{
    XtVaSetValues(widget(), XmNgaugeMargin, m, NULL);
}

int GaugeClass::gaugeMargin() const
{
    int m;
    XtVaGetValues(widget(), XmNgaugeMargin, &m, NULL);
    return m;
}

void GaugeClass::fill(Boolean f)
{
    XtVaSetValues(widget(), XmNfill, f, NULL);
}

Boolean GaugeClass::fill() const
{
    Boolean f;
    XtVaGetValues(widget(), XmNfill, &f, NULL);
    return f;
}

void GaugeClass::maximum(int m)
{
    XtVaSetValues(widget(), XmNmaximum, m, NULL);
}

int GaugeClass::maximum() const
{
    int m;
    XtVaGetValues(widget(), XmNmaximum, &m, NULL);
    return m;
}

void GaugeClass::minimum(int m)
{
    XtVaSetValues(widget(), XmNminimum, m, NULL);
}

int GaugeClass::minimum() const
{
    int m;
    XtVaGetValues(widget(), XmNminimum, &m, NULL);
    return m;
}

void GaugeClass::orientation(unsigned char p)
{
    XtVaSetValues(widget(), XmNorientation, p, NULL);
}

unsigned char GaugeClass::orientation() const
{
    unsigned char p;
    XtVaGetValues(widget(), XmNorientation, &p, NULL);
    return p;
}

void GaugeClass::processingDirection(unsigned char p)
{
    XtVaSetValues(widget(), XmNprocessingDirection, p, NULL);
}

unsigned char GaugeClass::processingDirection() const
{
    unsigned char p;
    XtVaGetValues(widget(), XmNprocessingDirection, &p, NULL);
    return p;
}

void GaugeClass::showMinMax(Boolean b)
{
    XtVaSetValues(widget(), XmNshowMinMax, b, NULL);
}

Boolean GaugeClass::showMinMax() const
{
    Boolean b;
    XtVaGetValues(widget(), XmNshowMinMax, &b, NULL);
    return b;
}

void GaugeClass::showPercentage(Boolean b)
{
    XtVaSetValues(widget(), XmNshowPercentage, b, NULL);
}

Boolean GaugeClass::showPercentage() const
{
    Boolean b;
    XtVaGetValues(widget(), XmNshowPercentage, &b, NULL);
    return b;
}

void GaugeClass::showValue(Boolean b)
{
    XtVaSetValues(widget(), XmNshowValue, b, NULL);
}

Boolean GaugeClass::showValue() const
{
    Boolean b;
    XtVaGetValues(widget(), XmNshowValue, &b, NULL);
    return b;
}

#if 1
void GaugeClass::sliderColor(Pixel d)
{
    XtVaSetValues(widget(), XmNsliderColor, d, NULL);
}

void GaugeClass::sliderColor(const char *d)
{
    XtVaSetValues(widget(), 
                  XtVaTypedArg, XmNsliderColor, 
                  XmRString, d, (strlen(d) + 1),
                  NULL);
}

Pixel GaugeClass::sliderColor() const
{
    Pixel d;
    XtVaGetValues(widget(), XmNsliderColor, &d, NULL);
    return d;
}
#endif

void GaugeClass::sliderShadowThickness(int t)
{
    XtVaSetValues(widget(), XmNsliderShadowThickness, t, NULL);
}

int GaugeClass::sliderShadowThickness() const
{
    int t;
    XtVaGetValues(widget(), XmNsliderShadowThickness, &t, NULL);
    return t;
}

void GaugeClass::sliderSize(int t)
{
    XtVaSetValues(widget(), XmNsliderSize, t, NULL);
}

int GaugeClass::sliderSize() const
{
    int t;
    XtVaGetValues(widget(), XmNsliderSize, &t, NULL);
    return t;
}

void GaugeClass::tickIncrement(int t)
{
    XtVaSetValues(widget(), XmNtickIncrement, t, NULL);
}

int GaugeClass::tickIncrement() const
{
    int t;
    XtVaGetValues(widget(), XmNtickIncrement, &t, NULL);
    return t;
}

void GaugeClass::troughColor(Pixel d)
{
    XtVaSetValues(widget(), XmNtroughColor, d, NULL);
}

void GaugeClass::troughColor(const char *d)
{
    XtVaSetValues(widget(), 
                  XtVaTypedArg, XmNtroughColor, 
                  XmRString, d, (strlen(d) + 1),
                  NULL);
}

Pixel GaugeClass::troughColor() const
{
    Pixel d;
    XtVaGetValues(widget(), XmNtroughColor, &d, NULL);
    return d;
}

void GaugeClass::troughShadowThickness(int t)
{
    XtVaSetValues(widget(), XmNtroughShadowThickness, t, NULL);
}

int GaugeClass::troughShadowThickness() const
{
    int t;
    XtVaGetValues(widget(), XmNtroughShadowThickness, &t, NULL);
    return t;
}

void GaugeClass::value(int v)
{
    XtVaSetValues(widget(), XmNvalue, v, NULL);
}

int GaugeClass::value() const
{
    int v;
    XtVaGetValues(widget(), XmNvalue, &v, NULL);
    return v;
}

Widget GaugeClass::createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist,
                               Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreateGauge(w_parent, name, arglist, cnt);
}
 


/* constructors */
Gauge::Gauge(Widget w_parent, ArgList arglist, Cardinal cnt,
                           _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt);

   widget(w);
   manage();
}

Gauge::Gauge(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
   manage();
}

Gauge::Gauge(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   manage();
}
