/* $Id: FileSB.C,v 1.4 1999/01/15 09:47:23 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/FileSB.h>

/* FileSelectionBoxClass Members */
/* convenience routines */
Widget
FileSelectionBoxClass::getChild(unsigned char child)
{
   return XmFileSelectionBoxGetChild(widget(),child);
}

void
FileSelectionBoxClass::doSearch(const char *dirmask)
{
   XmString xmstr = cvtStringToXmString(dirmask);
   XmFileSelectionDoSearch(widget(),xmstr);
   XmStringFree(xmstr);
}

/* resources */
void
FileSelectionBoxClass::directory(const char *d)
{
   XmString xmstr = cvtStringToXmString(d);
   XtVaSetValues(widget(), XmNdirectory, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
FileSelectionBoxClass::directory() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNdirectory, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
FileSelectionBoxClass::directoryValid(Boolean b)
{
   XtVaSetValues(widget(), XmNdirectoryValid, b, NULL);
}

Boolean
FileSelectionBoxClass::directoryValid() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNdirectoryValid, &b, NULL);
   return b;
}

void
FileSelectionBoxClass::dirListItems(const XmStringTable st)
{
   XtVaSetValues(widget(), XmNdirListItems, st, NULL);
}

XmStringTable
FileSelectionBoxClass::dirListItems() const
{
   XmStringTable st;
   XtVaGetValues(widget(), XmNdirListItems, &st, NULL);
   return st;
}

void
FileSelectionBoxClass::dirListItemCount(int i)
{
   XtVaSetValues(widget(), XmNdirListItemCount, i, NULL);
}

int
FileSelectionBoxClass::dirListItemCount() const
{
   int i;
   XtVaGetValues(widget(), XmNdirListItemCount, &i, NULL);
   return i;
}

void
FileSelectionBoxClass::dirListLabelString(const char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNdirListLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
FileSelectionBoxClass::dirListLabelString() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNdirListLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
FileSelectionBoxClass::dirMask(const char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNdirMask, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
FileSelectionBoxClass::dirMask() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNdirMask, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
FileSelectionBoxClass::dirSearchProc(XmSearchProc fp)
{
   XtVaSetValues(widget(), XmNdirSearchProc, fp, NULL);
}

XmSearchProc
FileSelectionBoxClass::dirSearchProc() const
{
   XmSearchProc fp;
   XtVaGetValues(widget(), XmNdirSearchProc, &fp, NULL);
   return fp;
}

void
FileSelectionBoxClass::dirSpec(const char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNdirSpec, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
FileSelectionBoxClass::dirSpec() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNdirSpec, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
FileSelectionBoxClass::fileListItems(const XmStringTable st)
{
   XtVaSetValues(widget(), XmNfileListItems, st, NULL);
}

XmStringTable
FileSelectionBoxClass::fileListItems() const
{
   XmStringTable st;
   XtVaGetValues(widget(), XmNfileListItems, &st, NULL);
   return st;
}

void
FileSelectionBoxClass::fileListItemCount(int i)
{
   XtVaSetValues(widget(), XmNfileListItemCount, i, NULL);
}

int
FileSelectionBoxClass::fileListItemCount() const
{
   int i;
   XtVaGetValues(widget(), XmNfileListItemCount, &i, NULL);
   return i;
}

void
FileSelectionBoxClass::fileListLabelString(const char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNfileListLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
FileSelectionBoxClass::fileListLabelString() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNfileListLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
FileSelectionBoxClass::fileSearchProc(XmSearchProc fp)
{
   XtVaSetValues(widget(), XmNfileSearchProc, fp, NULL);
}

XmSearchProc
FileSelectionBoxClass::fileSearchProc() const
{
   XmSearchProc fp;
   XtVaGetValues(widget(), XmNfileSearchProc, &fp, NULL);
   return fp;
}

void
FileSelectionBoxClass::fileTypeMask(unsigned char c)
{
   XtVaSetValues(widget(), XmNfileTypeMask, c, NULL);
}

unsigned char
FileSelectionBoxClass::fileTypeMask() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNfileTypeMask, &c, NULL);
   return c;
}

void
FileSelectionBoxClass::filterLabelString(const char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNfilterLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
FileSelectionBoxClass::filterLabelString() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNfilterLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
FileSelectionBoxClass::listUpdated(Boolean b)
{
   XtVaSetValues(widget(), XmNlistUpdated, b, NULL);
}

Boolean
FileSelectionBoxClass::listUpdated() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNlistUpdated, &b, NULL);
   return b;
}

void
FileSelectionBoxClass::noMatchString(const char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNnoMatchString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
FileSelectionBoxClass::noMatchString() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNnoMatchString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
FileSelectionBoxClass::pattern(const char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNpattern, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
FileSelectionBoxClass::pattern() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNpattern, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
FileSelectionBoxClass::qualifySearchDataProc(XmQualifyProc fp)
{
   XtVaSetValues(widget(), XmNqualifySearchDataProc, fp, NULL);
}

XmQualifyProc
FileSelectionBoxClass::qualifySearchDataProc() const
{
   XmQualifyProc fp;
   XtVaGetValues(widget(), XmNqualifySearchDataProc, &fp, NULL);
   return fp;
}

/* constructors */
FileSelectionBox::FileSelectionBox(Widget w_parent, 
                   ArgList arglist, 
                   Cardinal cnt, 
                   _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt); 
   widget(w);
}

FileSelectionBox::FileSelectionBox(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
}

FileSelectionBox::FileSelectionBox(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent); 
   widget(w);
}

Widget
FileSelectionDialog::createWidget(_XtString name,
                          Widget w_parent, 
                          ArgList arglist,
                          Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreateFileSelectionDialog(w_parent,name,arglist,cnt); 
}

FileSelectionDialog::FileSelectionDialog(Widget w_parent,
                         ArgList arglist,
                         Cardinal cnt,
                         _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt); 
   widget(w);
}

FileSelectionDialog::FileSelectionDialog(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
}

FileSelectionDialog::FileSelectionDialog(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent); 
   widget(w);
}

