/* $Id: Dial.C,v 1.2 1999/01/15 01:50:58 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/Dial.h>
/* Dial Members */

void DialClass::minimum(int m)
{
    XtVaSetValues(widget(), XmNminimum, m, NULL);
}

int DialClass::minimum() const
{
    int m;
    XtVaGetValues(widget(), XmNminimum, &m, NULL);
    return m;
}

void DialClass::maximum(int m)
{
    XtVaSetValues(widget(), XmNmaximum, m, NULL);
}

int DialClass::maximum() const
{
    int m;
    XtVaGetValues(widget(), XmNmaximum, &m, NULL);
    return m;
}

void DialClass::value(int v)
{
    XtVaSetValues(widget(), XmNvalue, v, NULL);
}

int DialClass::value() const
{
    int v;
    XtVaGetValues(widget(), XmNvalue, &v, NULL);
    return v;
}

void DialClass::tickIncrement(int t)
{
    XtVaSetValues(widget(), XmNtickIncrement, t, NULL);
}

int DialClass::tickIncrement() const
{
    int t;
    XtVaGetValues(widget(), XmNtickIncrement, &t, NULL);
    return t;
}

void DialClass::tickSize(int t)
{
    XtVaSetValues(widget(), XmNtickSize, t, NULL);
}

int DialClass::tickSize() const
{
    int t;
    XtVaGetValues(widget(), XmNtickSize, &t, NULL);
    return t;
}

void DialClass::arcMargin(int m)
{
    XtVaSetValues(widget(), XmNarcMargin, m, NULL);
}

int DialClass::arcMargin() const
{
    int m;
    XtVaGetValues(widget(), XmNarcMargin, &m, NULL);
    return m;
}

void DialClass::borderMargin(int m)
{
    XtVaSetValues(widget(), XmNborderMargin, m, NULL);
}

int DialClass::borderMargin() const
{
    int m;
    XtVaGetValues(widget(), XmNborderMargin, &m, NULL);
    return m;
}

void DialClass::processingDirection(unsigned char p)
{
    XtVaSetValues(widget(), XmNprocessingDirection, p, NULL);
}

unsigned char DialClass::processingDirection() const
{
    unsigned char p;
    XtVaGetValues(widget(), XmNprocessingDirection, &p, NULL);
    return p;
}

void DialClass::fill(Boolean f)
{
    XtVaSetValues(widget(), XmNfill, f, NULL);
}

Boolean DialClass::fill() const
{
    Boolean f;
    XtVaGetValues(widget(), XmNfill, &f, NULL);
    return f;
}

void DialClass::showValue(Boolean b)
{
    XtVaSetValues(widget(), XmNshowValue, b, NULL);
}

Boolean DialClass::showValue() const
{
    Boolean b;
    XtVaGetValues(widget(), XmNshowValue, &b, NULL);
    return b;
}

void DialClass::showMinMax(Boolean b)
{
    XtVaSetValues(widget(), XmNshowMinMax, b, NULL);
}

Boolean DialClass::showMinMax() const
{
    Boolean b;
    XtVaGetValues(widget(), XmNshowMinMax, &b, NULL);
    return b;
}

void DialClass::showPercentage(Boolean b)
{
    XtVaSetValues(widget(), XmNshowPercentage, b, NULL);
}

Boolean DialClass::showPercentage() const
{
    Boolean b;
    XtVaGetValues(widget(), XmNshowPercentage, &b, NULL);
    return b;
}

void DialClass::showHub(Boolean b)
{
    XtVaSetValues(widget(), XmNshowHub, b, NULL);
}

Boolean DialClass::showHub() const
{
    Boolean b;
    XtVaGetValues(widget(), XmNshowHub, &b, NULL);
    return b;
}

void DialClass::style(const DialStyle d)
{
    XtVaSetValues(widget(), XmNstyle, d, NULL);
}

DialStyle DialClass::style() const
{
    DialStyle d;
    XtVaGetValues(widget(), XmNstyle, &d, NULL);
    return d;
}

Widget DialClass::createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist,
                               Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreateDial(w_parent, name, arglist, cnt);
}
 


/* constructors */
Dial::Dial(Widget w_parent, ArgList arglist, Cardinal cnt,
                           _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt);

   widget(w);
   manage();
}

Dial::Dial(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
   manage();
}

Dial::Dial(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   manage();
}
