/* $Id: ComboBox.C,v 1.9 1999/01/15 01:32:05 glgay Exp $ */
/*
 Copyright (C) 1997 Gerald L. Gay
 Copyright (C) 1996 Peter Williams

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#include <Xarm/ComboBox.h>

/*
* The ComboBox only exists in versions of Motif >= 2.
* However, you could write one yourself and remove this restriction.
*/
#if XmVERSION >= 2

#include <Xm/ComboBoxP.h>

#if !defined(CB_List)
#define CB_List(w) \
	(((XmComboBoxWidget)(w))->combo_box.list)
#endif

/* callbacks */
void
ComboBoxClass::selectionCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNselectionCallback,fp,udata);
}

/* resources */

void
ComboBoxClass::arrowSize(Dimension d)
{
   XtVaSetValues(widget(),XmNarrowSize,d,NULL);
}

Dimension
ComboBoxClass::arrowSize() const
{
   Dimension d;
   XtVaGetValues(widget(),XmNarrowSize, &d,NULL);
   return d;
}

void
ComboBoxClass::arrowSpacing(Dimension d)
{
   XtVaSetValues(widget(),XmNarrowSpacing,d,NULL);
}

Dimension
ComboBoxClass::arrowSpacing() const
{
   Dimension d;
   XtVaGetValues(widget(),XmNarrowSpacing, &d,NULL);
   return d;
}

void
ComboBoxClass::highlightThickness(Dimension d)
{
   XtVaSetValues(widget(),XmNhighlightThickness,d,NULL);
}

Dimension
ComboBoxClass::highlightThickness() const
{
   Dimension d;
   XtVaGetValues(widget(),XmNhighlightThickness, &d,NULL);
   return d;
}

void
ComboBoxClass::fontList(const XmFontList fl)
{
   XtVaSetValues(widget(),XmNfontList, fl, NULL);
}

XmFontList
ComboBoxClass::fontList() const
{
   XmFontList f;
   XtVaGetValues(widget(),XmNfontList, &f, NULL);
   return f;
}

void
ComboBoxClass::matchBehavior(unsigned char c)
{
   XtVaSetValues(widget(), XmNmatchBehavior, c, NULL);
}

unsigned char
ComboBoxClass::matchBehavior() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNmatchBehavior, &c, NULL);
   return c;
}

void
ComboBoxClass::renderTable(const XmRenderTable t)
{
   XtVaSetValues(widget(), XmNrenderTable, t, NULL);
}

XmRenderTable 
ComboBoxClass::renderTable() const
{
   XmRenderTable t;
   XtVaGetValues(widget(), XmNrenderTable, &t, NULL);
   return t;
}

unsigned char
ComboBoxClass::comboBoxType() const
{
   unsigned char c;
   XtVaGetValues(widget(),XmNcomboBoxType, &c,NULL);
   return c;
}

void
ComboBoxClass::marginHeight(Dimension h)
{
   XtVaSetValues(widget(),XmNmarginHeight,h, NULL);
}

Dimension
ComboBoxClass::marginHeight() const
{
   Dimension d;
   XtVaGetValues(widget(),XmNmarginHeight, &d, NULL);
   return d;
}

void
ComboBoxClass::marginWidth(Dimension w)
{
   XtVaSetValues(widget(),XmNmarginWidth,w, NULL);
}

Dimension
ComboBoxClass::marginWidth() const
{
   Dimension d;
   XtVaGetValues(widget(),XmNmarginWidth, &d, NULL);
   return d;
}

void
ComboBoxClass::selectedItem(const char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNselectedItem, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
ComboBoxClass::selectedItem() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNselectedItem, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
ComboBoxClass::selectedPosition(int i)
{
   XtVaSetValues(widget(), XmNselectedPosition, i, NULL);
}

int
ComboBoxClass::selectedPosition() const
{
   int i;
   XtVaGetValues(widget(), XmNselectedPosition, &i, NULL);
   return i;
}

Widget
ComboBoxClass::createWidget(_XtString name,
                       Widget w_parent,
                       ArgList arglist,
                       Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreateComboBox(w_parent, name, arglist, cnt);
}

ComboBox::ComboBox(Widget w_parent,
            ArgList arglist, 
            Cardinal cnt,
            _XtString name)
{
   Widget w = createWidget(name, w_parent,arglist,cnt);
   widget(w);
   manage();
}

ComboBox::ComboBox(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
   manage();
}

ComboBox::ComboBox(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   manage();
}

Widget
DropDownList::createWidget(_XtString name,
                       Widget w_parent,
                       ArgList arglist,
                       Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreateDropDownList(w_parent, name, arglist, cnt);
}

DropDownList::DropDownList(Widget w_parent,
            ArgList arglist, 
            Cardinal cnt,
            _XtString name)
{
   Widget w = createWidget(name, w_parent,arglist,cnt);
   widget(w);
   manage();
}

DropDownList::DropDownList(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
   manage();
}

DropDownList::DropDownList(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   manage();
}

Widget
DropDownComboBox::createWidget(_XtString name,
                       Widget w_parent,
                       ArgList arglist,
                       Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreateDropDownComboBox(w_parent, name, arglist, cnt);
}

DropDownComboBox::DropDownComboBox(Widget w_parent,
            ArgList arglist, 
            Cardinal cnt,
            _XtString name)
{
   Widget w = createWidget(name, w_parent,arglist,cnt);
   widget(w);
   manage();
}

DropDownComboBox::DropDownComboBox(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
   manage();
}

DropDownComboBox::DropDownComboBox(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   manage();
}


/* convenience routines */
Widget
ComboBoxClass::list() const
{
   return (Widget) CB_List(widget());
}

void
ComboBoxClass::update()
{
   XmComboBoxUpdate(widget());
}

void ComboBoxClass::add(const char *str)
{
    ListClass *theList = listObject();
    if (theList != NULL) {
        theList->add(str);
	update();
    }
}

void ComboBoxClass::clear()
{
    ListClass *theList = listObject();
    if (theList != NULL) {
	theList->clear();
	update();
    }
}
   
/* extras */
/* This is how you wrap existing widgets. */
class WrapList : public ListClass {
 public:
   WrapList(Widget w) { widget(w); }  
};

ListClass *
ComboBoxClass::listObject() const
{
   ListClass *foo; 

   foo = (ListClass *) WidgetToWObject(list());   
   if (foo == NULL)
   {  /* then no wrap yet so wrap it */
      foo = new WrapList(list());
   }
   return foo;
}

#endif
