/* $Id: CDEComboBox.C,v 1.7 1999/01/15 00:53:19 glgay Exp $ */
/*
 Copyright (C) 1996 Peter Williams

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#include <Xarm/ComboBox.h>

/*
* The ComboBox only exists in versions of Motif >= 2.
* However, you could write one yourself and remove this restriction.
*/
#ifdef XARM_HAS_CDE


/* callbacks */
void
ComboBoxClass::selectionCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(DtNselectionCallback,fp,udata);
}

/* resources */

unsigned char
ComboBoxClass::comboBoxType() const
{
   unsigned char c;
   XtVaGetValues(widget(),DtNcomboBoxType, &c,NULL);
   return c;
}

void
ComboBoxClass::marginHeight(Dimension h)
{
   XtVaSetValues(widget(),DtNmarginHeight,h, NULL);
}

Dimension
ComboBoxClass::marginHeight() const
{
   Dimension d;
   XtVaGetValues(widget(),DtNmarginHeight, &d, NULL);
   return d;
}

void
ComboBoxClass::marginWidth(Dimension w)
{
   XtVaSetValues(widget(),DtNmarginWidth,w, NULL);
}

Dimension
ComboBoxClass::marginWidth() const
{
   Dimension d;
   XtVaGetValues(widget(),DtNmarginWidth, &d, NULL);
   return d;
}

void
ComboBoxClass::selectedItem(const char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   DtComboBoxSelectItem(widget(), xmstr);
   XmStringFree(xmstr);
}

char *
ComboBoxClass::selectedItem() const
{
   XmString xmstr;
   XtVaGetValues(widget(), DtNselectedItem, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
ComboBoxClass::selectedPosition(int i)
{
   XtVaSetValues(widget(), DtNselectedPosition, i, NULL);
}

int
ComboBoxClass::selectedPosition() const
{
   int i;
   XtVaGetValues(widget(), DtNselectedPosition, &i, NULL);
   return i;
}

Widget
ComboBoxClass::createWidget(_XtString name,
                       Widget w_parent,
                       ArgList arglist,
                       Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return DtCreateComboBox(w_parent, name, arglist, cnt);

}

ComboBox::ComboBox(Widget w_parent,
            ArgList arglist, 
            Cardinal cnt,
            _XtString name)
{
   Widget w = createWidget(name, w_parent,arglist,cnt);
   widget(w);
   manage();
}

ComboBox::ComboBox(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
   manage();
}

ComboBox::ComboBox(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   manage();
}

/* convenience routines */
Widget
ComboBoxClass::list() const
{
   return XtNameToWidget(widget(), "*List");
}

void ComboBoxClass::add(const char *str, int pos, Boolean unique)
{
   XmString xmstr = cvtStringToXmString(str);
   DtComboBoxAddItem(widget(), xmstr, pos, unique);
   XmStringFree(xmstr);
}

void ComboBoxClass::setItem(const char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   DtComboBoxSetItem(widget(), xmstr);
   XmStringFree(xmstr);
}

void ComboBoxClass::del(int pos)
{
   DtComboBoxDeletePos(widget(), pos);
}

void ComboBoxClass::clear()
{
    // This is a much faster clear function!
    // It works in Solaris CDE and in Linux/Xig CDE
    // Let me know if it causes anyone any problems

    XtVaSetValues(widget(), XmNitems, NULL, XmNitemCount, 0, NULL);
}
   
/* extras */
/* This is how you wrap existing widgets. */
class WrapList : public ListClass {
 public:
   WrapList(Widget w) { widget(w); }  
};

ListClass *
ComboBoxClass::listObject() const
{
   ListClass *foo; 

   foo = (ListClass *) WidgetToWObject(list());   
   if (foo == NULL)
   {  /* then no wrap yet so wrap it */
      foo = new WrapList(list());
   }
   return foo;
}

#endif

