/* $Id: AppContext.C,v 1.3 1999/01/15 10:36:44 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

/* Include(s): */
#include <stdlib.h>
#include <Xarm/AppContext.h>
#include <Xarm/ImageCache.h>

/* AppContext */

/*
*  AppContext\(\)
*
*  The classes constructor.
*/
AppContext::AppContext(const char *app_class, 
                       XrmOptionDescList options, 
                       Cardinal no, 
                       int &argc_in_out, 
                       char **argv_in_out, 
                       _XtString *fallbacks)
{
   XtAppContext ac;
   Widget wid = XtVaAppInitialize(
      &ac,                      /* application context */
      app_class,                /* application class */
      options, no,              /* command line option list */
      &argc_in_out, argv_in_out,/* command line args */
      fallbacks,                /* for missing app-defaults file */
      NULL);                    /* terminate varags list */

   widget(wid);
   appContext(ac);

   /* install extra resource converters */
   registerConverters();

#if 0

   /* add my hooks */
   XtActionsRec actions[1];

   /* this is so mnemonics work out of menu's */
   actions[0].string = "activate";
   actions[0].proc = (XtActionProc) AppContext::activate; 

   addActions(actions, 1);

#endif

}

#if 0

void 
AppContext::activate(Widget w, XEvent *event, _XtString *s, unsigned int *num) {
   Widget child;
   num = num;
   w = w;

   /* >>>>>>>>>>> this is system dependent */
   /* use sizeof(ptrdiff_t) (?) & sprintf to form a format string to make this 
      system independent */
   sscanf(s[0],"%lu", (unsigned long) &child);

   XtCallCallbacks(child,XmNactivateCallback, (char *) event);
}

#endif


/* AppContextClass member functions */

void
AppContextClass::addActions(const XtActionList list, const Cardinal no)
{
   XtAppAddActions(appContext(), list, no);
}

void 
AppContextClass::addConverter(_XtString from_type, _XtString to_type, 
                              XtConverter converter, 
                              XtConvertArgList convert_args, Cardinal no_args)
{
   XtAppAddConverter(appContext(), from_type, to_type, converter, convert_args,
                     no_args);
}

XtInputId 
AppContextClass::addInput(int source, XtPointer condition, 
                          XtInputCallbackProc proc, XtPointer client_data)
{
   return XtAppAddInput(appContext(), source, condition, proc, client_data);
}

XtIntervalId 
AppContextClass::addTimeOut(unsigned long interval, XtTimerCallbackProc proc, 
                           XtPointer client_data)
{
   return XtAppAddTimeOut(appContext(), interval, proc, client_data);
}

XtWorkProcId 
AppContextClass::addWorkProc(XtWorkProc proc, XtPointer client_data)
{
   return XtAppAddWorkProc(appContext(), proc, client_data);
}

Boolean 
AppContextClass::dispatchEvent(XEvent *event)
{
   return XtDispatchEvent(event);
}

void 
AppContextClass::error(const _XtString msg)
{
   XtAppError(appContext(), msg);
}

void 
AppContextClass::errorMsg(_XtString name, _XtString type, _XtString _class, 
                          _XtString _default, _XtString *params, Cardinal *no)
{
   XtAppErrorMsg(appContext(), name, type, _class, _default, params, no);
}

XrmDatabase *
AppContextClass::getErrorDatabase()
{
   return XtAppGetErrorDatabase(appContext());
}

void 
AppContextClass::getErrorDatabaseText(char *name, char *type, char *_class,
                             char *_default, char *buffer_return, int nbytes, 
                             XrmDatabase database)
{
   XtAppGetErrorDatabaseText(appContext(),name,type,_class,_default,
                             buffer_return, nbytes, database);
}

unsigned long 
AppContextClass::getSelectionTimeout() const
{
   return XtAppGetSelectionTimeout(appContext());
}

/*
* mainLoop\(\)
*
* This is the main loop
*
*/
void
AppContextClass::mainLoop()
{
   XEvent ev;
   doneProcessing = false;

   while (!doneProcessing) {
       nextEvent(&ev);
       dispatchEvent(&ev);
   }

   // If there are any leftover events
   // then process them...

   while (pending()) {
       nextEvent(&ev);
       dispatchEvent(&ev);
   }
}

void 
AppContextClass::nextEvent(XEvent * event_return)
{
   XtAppNextEvent(appContext(),event_return);
}

void 
AppContextClass::processEvent(XtInputMask mask) 
{
   XtAppProcessEvent(appContext(),mask);
}

Boolean
AppContextClass::peekEvent(XEvent * event_return)
{
   return XtAppPeekEvent(appContext(), event_return);
}

XtInputMask 
AppContextClass::pending()
{
   return XtAppPending(appContext());
}

void 
AppContextClass::removeInput(XtInputId id)
{
   XtRemoveInput(id);
}

void 
AppContextClass::removeTimeOut(XtIntervalId timer)
{
   XtRemoveTimeOut(timer);
}

void 
AppContextClass::removeWorkProc(XtWorkProcId id)
{
   XtRemoveWorkProc(id);
}

void 
AppContextClass::setErrorHandler(XtErrorHandler handler)
{
   XtAppSetErrorHandler(appContext(), handler);
}

void 
AppContextClass::setErrorMsgHandler(XtErrorMsgHandler handler)
{
   XtAppSetErrorMsgHandler(appContext(), handler);
}

void 
AppContextClass::setSelectionTimeout(unsigned long timeout)
{
   XtAppSetSelectionTimeout(appContext(), timeout);
}

void 
AppContextClass::setWarningHandler(XtErrorHandler handler)
{
   XtAppSetWarningHandler(appContext(), handler);
}

void 
AppContextClass::setWarningMsgHandler(XtErrorMsgHandler handler)
{
   XtAppSetWarningMsgHandler(appContext(), handler);
}

void 
AppContextClass::warning(_XtString msg)
{
   XtAppWarning(appContext(), msg);
}

void
AppContextClass::warningMsg(_XtString name, _XtString type, _XtString _class, _XtString _default,
                   _XtString *params, Cardinal *no)
{
   XtAppWarningMsg(appContext(), name, type, _class, _default, params, no);
}

/*
* quit\(\)
*
* This is used to exit the application
*/
void
AppContextClass::quit(bool now)
{
   if (now) {
       exit(EXIT_SUCCESS);
   } else {
       doneProcessing = true;
   }
}

/* do not specify  return type for conversion routine */
AppContextClass::operator XtAppContext() const
{ 
   return appContext(); 
}

void
AppContextClass::registerConverters()
{
   XarmRegisterConverters();
}
