/* $Id: Tab.h,v 1.2 1998/04/18 05:45:09 glgay Exp $ */
/*
 Copyright (C) 1996 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XM_TAB_H_)
#define _XM_TAB_H_

#include <Xm/Label.h>

#if defined(__cplusplus)
extern "C" {
#endif

/* ======================================================================== */
/* Tab Widget */

extern WidgetClass xmTabWidgetClass;
typedef struct _XmTabRec *XmTabWidget;
typedef struct _XmTabClassRec *XmTabWidgetClass;

#define XmIsTab(w) XtIsSubclass((w), xmTabWidgetClass)

Widget XmCreateTab(Widget parent,  
                   char *name, 
                   Arg *arglist, 
                   Cardinal argcount);

/* new resources */
#define XmNcornerStyle "cornerStyle"        /* CSG, enum type */
#define XmCCornerStyle "CornerStyle"      
#define XmNcornerSize "cornerSize"         /* CSG, x <= 20, but x >= 0 */
#define XmCCornerSize "CornerSize"      
#define XmNshowAsActive "showAsActive"      /* CSG, boolean */
#define XmCShowAsActive "ShowAsActive"     

/* enums for corner style */
enum {
   XmCORNER_NONE,
   XmCORNER_LINE,
   XmCORNER_ARC
};

/* callback structure */
#define XmTabCallbackStruct XmAnyCallbackStruct

#if 0
/* Tab Resource Set */
Name                  Class                 Type             Default      Access
--------------------------------------------------------------------------------
XmNactivateCallback   XmCCallback           XtCallbackList   NULL         C
XmNarmCallback        XmCCallback           XtCallbackList   NULL         C
XmNarmColor           XmCArmColor           Pixel            dynamic      CSG
XmNarmPixmap          XmCArmPixmap          Pixmap           XmUNSPECIF\  CSG
                                                             IED_PIXMAP
XmNcornerStyle        XmCCornerStyle        int              XmCORNER_\   CSG
                                                             LINE
XmNcornerSize         XmCCornerSize         int              0            CSG
XmNdisarmCallback     XmCCallback           XtCallbackList   NULL         C
XmNfillOnArm          XmCFillOnArm          Boolean          False        CSG
XmNshowAsActive       XmCShowAsActive       Boolean          False        CSG

/* Overridden Inherited Resources */
Name                  Class                 Type             Default      Access
--------------------------------------------------------------------------------
XmNrecomputeSize      XmCRecomputeSize      Boolean          True         CSG
XmNtraversalOn        XmCTraversalOn        Boolean          True         CSG
XmNhighlightThickness XmCHighlightThickness Dimension        2            CSG
XmNshadowThickness    XmCShadowThickness    Dimension        2            CSG

#endif


#if defined(__cplusplus)
}
#endif

#endif

