/*
 Copyright (C) 1998 Nikolay Mladenov

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#ifndef _XARM_XARMWIDGET_H_
#define _XARM_XARMWIDGET_H_

////////////////////////////////////////////////////////////////////////////////
//
//  This is useful in cases like:
//
//  SelectionDialog *dialog = new SelectionDialog(.........);
//  XarmWidget<ListClass> list(dialog->getChild(XmDIALOG_LIST));
//  list.add("something");
//  list.replace( .....;
//
////////////////////////////////////////////////////////////////////////////////


template <class WidgetClass_T>
class XarmWidget: public WidgetClass_T{
protected:
        _XtString className() { return "WrappedWidget"; }
public:
        XarmWidget(Widget w) : WidgetClass_T() {
                widget(w);
        }
        XarmWidget<WidgetClass_T> &operator = ( Widget w) {
                widget(w);
                return *this;
        }
        XarmWidget<WidgetClass_T> &operator = ( XarmWidget<WidgetClass_T> & wc){
                return this->operator = (wc.widget());
        }
        XarmWidget(XarmWidget<WidgetClass_T> & wc):WidgetClass_T(){
                widget(wc.widget());
        }
        ~XarmWidget(){
                widget(0);
        }
};

#endif  // _XARM_XARMWIDGET_H_
