/*
 Copyright (C) 1998, Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#if !defined(_XARM_MATRIX_H)
#define _XARM_MATRIX_H

#include <Xarm/Xarm.h>
#include <Xarm/Manager.h>

#ifdef XARM_HAS_XBAE

#include <Xbae/Matrix.h>

typedef Pixel          **PixelTable;
typedef String         **CellTable;
typedef Boolean         *BooleanArray;
typedef Boolean        **BooleanTable;
typedef String          *StringArray;
typedef unsigned char    GridType;
typedef unsigned char  **HighlightTable;
typedef XtTranslations   TranslationTable;

class MatrixClass : public ManagerClass {

 protected:

    MatrixClass() {}

    virtual WidgetClass classPointer() { return xbaeMatrixWidgetClass; }
    virtual _XtString   className()    { return (_XtString) "XbaeMatrix"; }

 public:

    /* Callbacks */
    void defaultActionCallback(XtCallbackProc funcp, XtPointer data = NULL);
    void drawCellCallback(XtCallbackProc funcp, XtPointer data = NULL);
    void enterCellCallback(XtCallbackProc funcp, XtPointer data = NULL);
    void labelActivateCallback(XtCallbackProc funcp, XtPointer data = NULL);
    void leaveCellCallback(XtCallbackProc funcp, XtPointer data = NULL);
    void modifyVerifyCallback(XtCallbackProc funcp, XtPointer data = NULL);
    void processDragCallback(XtCallbackProc funcp, XtPointer data = NULL);
    void resizeCallback(XtCallbackProc funcp, XtPointer data = NULL);
    void resizeColumnCallback(XtCallbackProc funcp, XtPointer data = NULL);
    void selectCellCallback(XtCallbackProc funcp, XtPointer data = NULL);
    void traverseCellCallback(XtCallbackProc funcp, XtPointer data = NULL);
    void writeCellCallback(XtCallbackProc funcp, XtPointer data = NULL);

    /* Resources */
    void             allowColumnResize(Boolean);
    Boolean          allowColumnResize() const;
    void             altRowCount(int);
    int              altRowCount() const;
    void             boldLabels(Boolean);
    Boolean          boldLabels() const;
    void             buttonLabels(Boolean);
    Boolean          buttonLabels() const;
    void             buttonLabelBackground(Pixel);
    Pixel            buttonLabelBackground() const;
    void             cellBackgrounds(PixelTable);
    PixelTable       cellBackgrounds() const;
    void             cellHighlightThickness(Dimension);
    Dimension        cellHighlightThickness() const;
    void             cellMarginHeight(Dimension);
    Dimension        cellMarginHeight() const;
    void             cellMarginWidth(Dimension);
    Dimension        cellMarginWidth() const;
    void             cellShadowThickness(Dimension);
    Dimension        cellShadowThickness() const;
    void             cellShadowType(unsigned char);
    unsigned char    cellShadowType() const;
    void             cellShadowTypes(unsigned char **);
    unsigned char  **cellShadowTypes() const;
    void             cellUserData(XtPointer **);
    XtPointer      **cellUserData() const;
    Widget           clipWindow() const;
    void             cells(CellTable);
    CellTable        cells() const;
    void             colors(PixelTable);
    PixelTable       colors() const;
    void             columnAlignments(AlignmentArray);
    AlignmentArray   columnAlignments() const;
    void             columnButtonLabels(BooleanArray);
    BooleanArray     columnButtonLabels() const;
    void             columnLabelAlignments(AlignmentArray);
    AlignmentArray   columnLabelAlignments() const;
    void             columnLabelColor(Pixel);
    Pixel            columnLabelColor() const;
    void             columnLabels(StringArray);
    StringArray      columnLabels() const;
    void             columnMaxLengths(MaxLengthArray);
    MaxLengthArray   columnMaxLengths() const;
    void             columnShadowTypes(unsigned char *);
    unsigned char   *columnShadowTypes() const;
    void             columnUserData(XtPointer *);
    XtPointer       *columnUserData() const;
    void             columnWidths(WidthArray);
    WidthArray       columnWidths() const;
    void             columns(int);
    int              columns() const;
    void             doubleClickInterval(int);
    int              doubleClickInterval() const;
    void             evenRowBackground(Pixel);
    Pixel            evenRowBackground() const;
    void             fill(Boolean);
    Boolean          fill() const;
    void             fixedColumns(Dimension);
    Dimension        fixedColumns() const;
    void             fixedRows(Dimension);
    Dimension        fixedRows() const;
    void             fontList(const XmFontList);
    XmFontList       fontList() const;
    void             gridLineColor(Pixel);
    Pixel            gridLineColor() const;
    void             gridType(GridType);
    GridType         gridType() const;
    void             highlightedCells(HighlightTable);
    HighlightTable   highlightedCells() const;
    Widget           horizontalScrollBar() const;
    void             horizontalScrollBarDisplayPolicy(unsigned char);
    unsigned char    horizontalScrollBarDisplayPolicy() const;
    void             labelFont(const XmFontList);
    XmFontList       labelFont() const;
    void             leftColumn(int);
    int              leftColumn() const;
    void             oddRowBackground(Pixel);
    Pixel            oddRowBackground() const;
    void             reverseSelect(Boolean);
    Boolean          reverseSelect() const;
    void             rowButtonLabels(BooleanArray);
    BooleanArray     rowButtonLabels() const;
    void             rowLabelAlignment(Alignment);
    Alignment        rowLabelAlignment() const;
    void             rowLabelColor(Pixel);
    Pixel            rowLabelColor() const;
    void             rowLabelWidth(short);
    short            rowLabelWidth() const;
    void             rowLabels(StringArray);
    StringArray      rowLabels() const;
    void             rowShadowTypes(unsigned char *);
    unsigned char   *rowShadowTypes() const;
    void             rowUserData(XtPointer *);
    XtPointer       *rowUserData() const;
    void             rows(int);
    int              rows() const;
    void             scrollBarPlacement(unsigned char);
    unsigned char    scrollBarPlacement() const;
    void             selectScrollVisible(Boolean);
    Boolean          selectScrollVisible() const;
    void             selectedBackground(Pixel);
    Pixel            selectedBackground() const;
    void             selectedCells(BooleanTable);
    BooleanTable     selectedCells() const;
    void             selectedForeground(Pixel);
    Pixel            selectedForeground() const;
    void             shadowType(unsigned char);
    unsigned char    shadowType() const;
    void             showArrows(Boolean);
    Boolean          showArrows() const;
    void             space(Dimension);
    Dimension        space() const;
    void             textBackground(Pixel);
    Pixel            textBackground() const;
    Widget           textField() const;
    void             textShadowThickness(Dimension);
    Dimension        textShadowThickness() const;
    void             textTranslations(TranslationTable);
    TranslationTable textTranslations() const;
    void             topRow(int);
    int              topRow() const;
    void             trailingFixedColumns(Dimension);
    Dimension        trailingFixedColumns() const;
    void             trailingFixedRows(Dimension);
    Dimension        trailingFixedRows() const;
    void             traverseFixedCells(Boolean);
    Boolean          traverseFixedCells() const;
    Widget           verticalScrollBar() const;
    void             verticalScrollBarDisplayPolicy(unsigned char);
    unsigned char    verticalScrollBarDisplayPolicy() const;
    void             visibleColumns(Dimension);
    Dimension        visibleColumns() const;
    void             visibleRows(Dimension);
    Dimension        visibleRows() const;

    /* Convenience functions */
    /* NOTE:  Some of the arguments have been re-arranged from the actual */
    /*        Xbae calls to allow for easy default values */
    void addColumns(int position,
		    int num_columns,
		    String *columns                 = NULL,
		    String *labels                  = NULL,
		    short *widths                   = NULL,
		    int *max_lengths                = NULL,
		    unsigned char *alignments       = NULL,
		    unsigned char *label_alignments = NULL,
		    Pixel *colors                   = NULL) {
          XbaeMatrixAddColumns(widget(), position, columns, labels, widths, max_lengths,
			       alignments, label_alignments, colors, num_columns);
    }

    void addRows(int position,
		 int num_rows,
		 String *rows   = NULL,
		 String *labels = NULL,
		 Pixel *colors  = NULL) {
          XbaeMatrixAddRows(widget(), position, rows, labels, colors, num_rows);
    }

    void cancelEdit(Boolean unmap = False) { XbaeMatrixCancelEdit(widget(), unmap); }

    void commitEdit(Boolean unmap = True)  { XbaeMatrixCommitEdit(widget(), unmap); }

    void deleteColumns(int position, int num_columns) {
          XbaeMatrixDeleteColumns(widget(), position, num_columns);
    }

    void deleteRows(int position, int num_rows) {
          XbaeMatrixDeleteRows(widget(), position, num_rows);
    }

    void deselectAll() { XbaeMatrixDeselectAll(widget()); }

    void deselectCell(int row, int column) { XbaeMatrixDeselectCell(widget(), row, column); }

    void deselectColumn(int column) { XbaeMatrixDeselectColumn(widget(), column); }

    void deselectRow(int row) { XbaeMatrixDeselectRow(widget(), row); }

    void disableRedisplay() { XbaeMatrixDisableRedisplay(widget()); }

    void editCell(int row, int column) { XbaeMatrixEditCell(widget(), row, column); }

    void enableRedisplay(Boolean redisplay = True) { XbaeMatrixEnableRedisplay(widget(), redisplay); }

    Boolean eventToXY(XEvent *ev, int *x, int *y) { return XbaeMatrixEventToXY(widget(), ev, x, y); }

    void firstSelectedCell(int *row, int *column) { XbaeMatrixFirstSelectedCell(widget(), row, column); }

    int firstSelectedColumn() const { return XbaeMatrixFirstSelectedColumn(widget()); }

    int firstSelectedRow() const { return XbaeMatrixFirstSelectedRow(widget()); }

    String getCell(int row, int column) const { return XbaeMatrixGetCell(widget(), row, column); }

    XtPointer getCellUserData(int row, int column) const {
        return XbaeMatrixGetCellUserData(widget(), row, column);
    }

    String getColumnLabel(int column) const { return XbaeMatrixGetColumnLabel(widget(), column); }

    XtPointer getColumnUserData(int column) const { return XbaeMatrixGetColumnUserData(widget(), column); }

    void getCurrentCell(int *x, int *y) const { XbaeMatrixGetCurrentCell(widget(), x, y); }

    int getEventRowColumn(XEvent *ev, int *row, int *column) {
        return XbaeMatrixGetEventRowColumn(widget(), ev, row, column);
    }

    int getNumSelected() const { return XbaeMatrixGetNumSelected(widget()); }

    String getRowLabel(int row) const { return XbaeMatrixGetRowLabel(widget(), row); }

    XtPointer getRowUserData(int row) const { return XbaeMatrixGetRowUserData(widget(), row); }

    void hghlightCell(int row, int column) { XbaeMatrixHighlightCell(widget(), row, column); }

    void highlightColumn(int column) { XbaeMatrixHighlightColumn(widget(), column); }

    void highlightRow(int row) { XbaeMatrixHighlightRow(widget(), row); }

    Boolean isCellSelected(int row, int column) const { return XbaeMatrixIsCellSelected(widget(), row, column); }

    Boolean isCellVisible(int row, int column) const { return XbaeMatrixIsCellVisible(widget(), row, column); }

    Boolean isColumnSelected(int column) const { return XbaeMatrixIsColumnSelected(widget(), column); }

    Boolean isColumnVisible(int column) const { return XbaeMatrixIsColumnVisible(widget(), column); }

    Boolean isRowSelected(int row) const { return XbaeMatrixIsRowSelected(widget(), row); }

    Boolean isRowVisible(int row) const { return XbaeMatrixIsRowVisible(widget(), row); }

    void makeCellVisible(int row, int column) { XbaeMatrixMakeCellVisible(widget(), row, column); }

    int numRows() const { return XbaeMatrixNumRows(widget()); }

    int numColumns() const { return XbaeMatrixNumColumns(widget()); }

    void refresh() { XbaeMatrixRefresh(widget()); }

    void refreshCell(int row, int column) { XbaeMatrixRefreshCell(widget(), row, column); }

    int rowColToXY(int row, int col, int *x, int *y) const { return XbaeMatrixRowColToXY(widget(), row, col, x, y); }

    void selectAll() { XbaeMatrixSelectAll(widget()); }

    void selectCell(int row, int col) { XbaeMatrixSelectCell(widget(), row, col); }

    void selectColumn(int col) { XbaeMatrixSelectColumn(widget(), col); }

    void selectRow(int row) { XbaeMatrixSelectRow(widget(), row); }

    void setCell(int row, int col, String val) { XbaeMatrixSetCell(widget(), row, col, val); }

    void setCellBackground(int row, int col, Pixel color) {
        XbaeMatrixSetCellBackground(widget(), row, col, color);
    }

    void setCellColor(int row, int col, Pixel color) { XbaeMatrixSetCellColor(widget(), row, col, color); }

    void setCellUserData(int row, int col, XtPointer data) {
        XbaeMatrixSetCellUserData(widget(), row, col, data);
    }

    void setColumnBackgrounds(int pos, Pixel *colors, int num_colors) {
        XbaeMatrixSetColumnBackgrounds(widget(), pos, colors, num_colors);
    }

    void setColumnColors(int pos, Pixel *colors, int num_colors) {
        XbaeMatrixSetColumnColors(widget(), pos, colors, num_colors);
    }

    void setColumnLabel(int col, String val) { XbaeMatrixSetColumnLabel(widget(), col, val); }

    void setColumnUserData(int col, XtPointer data) { XbaeMatrixSetColumnUserData(widget(), col, data); }

    void setRowBackgrounds(int pos, Pixel *colors, int num_colors) {
        XbaeMatrixSetRowBackgrounds(widget(), pos, colors, num_colors);
    }

    void setRowColors(int pos, Pixel *colors, int num_colors) {
        XbaeMatrixSetRowColors(widget(), pos, colors, num_colors);
    }

    void setRowLabel(int row, String val) { XbaeMatrixSetRowLabel(widget(), row, val); }

    void setRowUserData(int row, XtPointer data) { XbaeMatrixSetRowUserData(widget(), row, data); }

    void unhighlightAll() { XbaeMatrixUnhighlightAll(widget()); }

    void unhighlightCell(int row, int col) { XbaeMatrixUnhighlightCell(widget(), row, col); }

    void unhighlightColumn(int col) { XbaeMatrixUnhighlightColumn(widget(), col); }

    void unhighlightRow(int row) { XbaeMatrixUnhighlightRow(widget(), row); }

    void visibleCells(int *top_row, int *bottom_row, int *left_column, int *right_column) {
        XbaeMatrixVisibleCells(widget(), top_row, bottom_row, left_column, right_column);
    }

    // Name collision!!!!!

    int getVisibleColumns() const { return XbaeMatrixVisibleColumns(widget()); }

    int getVisibleRows() const { return XbaeMatrixVisibleRows(widget()); }
};

class Matrix : public MatrixClass {

 public:

    Matrix(Widget w_parent,
	   ArgList arglist = NULL,
	   Cardinal cnt = 0,
	   _XtString name = NULL);
    Matrix(_XtString name, Widget w_parent);
    Matrix(Widget w_parent, XarmArg &args, _XtString name);
};


#endif // XARM_HAS_XBAE

#endif // _XARM_MATRIX_H
