/* $Id: TextF.h,v 1.3 1999/02/03 13:50:22 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_TEXTF_H_)
#define _XARM_TEXTF_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Primitive.h>

class TextFieldClass : public PrimitiveClass {
 protected:
   TextFieldClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer() { return xmTextFieldWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmTextField"; }
 public:
   /* callbacks */
   void activateCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void focusCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void gainPrimaryCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void losePrimaryCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void losingFocusCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void modifyVerifyCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void modifyVerifyCallbackWcs(XtCallbackProc funcp, XtPointer data = NULL);
   void motionVerifyCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void valueChangedCallback(XtCallbackProc funcp, XtPointer data = NULL);

   /* convenience functions */
   void clearSelection(Time time);
   Boolean copy(Time time);
   Boolean cut(Time time);
   int getBaseline() const;
   XmTextPosition getCursorPosition() const;
   Boolean getEditable() const;
   XmTextPosition getInsertionPosition() const;
   XmTextPosition getLastPosition() const;
   int getMaxLength() const;
   char *getSelection() const;
   Boolean getSelectionPosition(XmTextPosition *left, XmTextPosition *right);
   wchar_t *getSelectionWcs() const;
   char *getString() const;
   wchar_t *getStringWcs() const;
   int getSubstring(XmTextPosition start, int no_chars, int buf_sz, char *buf);
   int getSubstringWcs(XmTextPosition start, int no_chars, int buf_sz, 
                       wchar_t *buf);
   void insert(XmTextPosition pos, const char *str);
   void insertWcs(XmTextPosition pos, const wchar_t *str);
   Boolean paste() const;
   Boolean posToXY(XmTextPosition pos, Position *xpos, Position *ypos);
   Boolean remove();
   void replace(XmTextPosition from, XmTextPosition to, const char *val);
   void replaceWcs(XmTextPosition from, XmTextPosition to, const wchar_t *val);
   void setAddMode(Boolean state);
   void setCursorPosition(XmTextPosition pos);
   void setEditable(Boolean edit);
   void setHighlight(XmTextPosition left, XmTextPosition right,
                     XmHighlightMode mode);
   void setInsertionPosition(XmTextPosition pos);
   void setMaxLength(int max);
   void setSelection(XmTextPosition first, XmTextPosition last,
                     Time t);
   void setString(const char *str);
   void setStringWcs(const wchar_t *str);
   void showPosition(XmTextPosition pos);
   XmTextPosition xyToPos(Position xpos, Position ypos) const;
   
   /* resources */
   void blinkRate(int);
   int blinkRate() const;
   void columns(short);
   short columns() const;
   void cursorPosition(const XmTextPosition);
   XmTextPosition cursorPosition() const;
   void cursorPositionVisible(Boolean);
   Boolean cursorPositionVisible() const;
   void editable(Boolean);
   Boolean editable() const;
   void fontList(const XmFontList);
   XmFontList fontList() const;
   void marginHeight(Dimension);
   Dimension marginHeight() const;
   void marginWidth(Dimension);
   Dimension marginWidth() const;
   void maxLength(int);
   int maxLength() const;
   void pendingDelete(Boolean);
   Boolean pendingDelete() const;
   void resizeWidth(Boolean);
   Boolean resizeWidth() const;
   void selectionArray(const XmTextScanType *);
   XmTextScanType *selectionArray() const;
   void selectionArrayCount(int);
   int selectionArrayCount() const;
   void selectThreshold(int);
   int selectThreshold() const;
   void value(const _XtString);
   _XtString value() const;
   void valueWcs(const wchar_t *);
   wchar_t *valueWcs() const;
   void verifyBell(Boolean);
   Boolean verifyBell() const;
};

class TextField : public TextFieldClass {
 public:
   TextField(Widget w_parent,
             ArgList arglist = NULL,
             Cardinal cnt = 0,
             _XtString name = NULL);
   TextField(_XtString name, Widget w_parent);
   TextField(Widget w_parent, XarmArg &args, _XtString name);
};


#endif
