/* $Id: Tab.h,v 1.4 1999/02/03 13:50:22 glgay Exp $ */
/*
 Copyright (C) 1996 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_TAB_H_)
#define _XARM_TAB_H_

/*
 * Warning:  These classes diverge from the Motif 1.2 standard GUI and
 * use widgets written by the author.
 */

/* ======================================================================= */
/* Include(s): */
#include <Xmext/Tab.h>
#include <Xarm/Label.h>

class TabClass : public LabelClass {
 protected:
   TabClass() {} /* only a derived class can make this */

   virtual WidgetClass classPointer() { return xmTabWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmTab"; }
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   /* callbacks */
   void activateCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void armCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void disarmCallback(XtCallbackProc funcp, XtPointer data = NULL);

   /* resources */
   void armColor(Pixel);
   Pixel armColor() const;
   void armPixmap(Pixmap);
   Pixmap armPixmap() const;
   void cornerSize(int);
   int cornerSize() const;
   void cornerStyle(int);
   int cornerStyle() const;
   void fillOnArm(Boolean);
   Boolean fillOnArm() const;
   void showAsActive(Boolean);
   Boolean showAsActive() const;

   /* extra functionality */
   void autoSpace(int size = 100);
   void armColor(const char *);
};
   
class Tab : public TabClass {
 public:
   Tab(Widget w_parent, 
                char *str, 
                _XtString name = NULL);

   Tab(Widget w_parent, 
              ArgList arglist = NULL, 
              Cardinal cnt = 0,
              _XtString name = NULL);

   Tab(_XtString name, Widget w_parent);
   Tab(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
