/* $Id: SelectioB.h,v 1.3 1999/02/03 13:50:22 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_SELECTIOB_H_)
#define _XARM_SELECTIOB_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/BulletinB.h>

class SelectionBoxClass : public BulletinBoardClass {
 protected:
   SelectionBoxClass() {}
   virtual WidgetClass classPointer() { return xmSelectionBoxWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmSelectionBox"; }
 public:
   /* callbacks */
   void applyCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void cancelCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void noMatchCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void okCallback(XtCallbackProc funcp, XtPointer data = NULL);

   /* convenience routines */
   virtual Widget getChild(unsigned char);

   /* resources */
   void applyLabelString(const char *);
   char *applyLabelString() const;
   void cancelLabelString(const char *);
   char *cancelLabelString() const;
   void childPlacement(unsigned char);
   unsigned char childPlacement() const;
   void dialogType(unsigned char);
   unsigned char dialogType() const;
   void helpLabelString(const char *);
   char *helpLabelString() const;
   void listItemCount(int);
   int listItemCount() const;
   void listItems(const XmStringTable);
   XmStringTable listItems() const;
   void listLabelString(const char *);
   char *listLabelString() const;
   void listVisibleItemCount(int);
   int listVisibleItemCount() const;
   void minimizeButtons(Boolean);
   Boolean minimizeButtons() const;
   void mustMatch(Boolean);
   Boolean mustMatch() const;
   void okLabelString(const char *);
   char *okLabelString() const;
   void selectionLabelString(const char *str);
   char *selectionLabelString() const;
   void textColumns(short);
   short textColumns() const;
   void textString(const char *str);
   char *textString() const;
};

class SelectionBox : public SelectionBoxClass {
 protected:
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   SelectionBox(Widget w_parent, 
                ArgList arglist = NULL,
                Cardinal cnt = 0,
                _XtString name = NULL);
   SelectionBox(_XtString name, Widget w_parent);
   SelectionBox(Widget w_parent, XarmArg &args, _XtString name);
};

class SelectionDialog : public SelectionBoxClass {
 protected:
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   SelectionDialog(Widget w_parent,
                   ArgList arglist = NULL,
                   Cardinal cnt = 0,
                   _XtString name = NULL);
   SelectionDialog(_XtString name, Widget w_parent);
   SelectionDialog(Widget w_parent, XarmArg &args, _XtString name);
};

class PromptDialog : public SelectionBoxClass {
 protected:
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   PromptDialog(Widget w_parent, char *mesg, _XtString name = NULL);
   PromptDialog(Widget w_parent,
                ArgList arglist = NULL,
                Cardinal cnt = 0,
                _XtString name = NULL);
   PromptDialog(_XtString name, Widget w_parent);
   PromptDialog(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
