/* $Id: RectObj.h,v 1.2 1999/02/03 13:50:21 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_RECTOBJ_H_)
#define _XARM_RECTOBJ_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Object.h>

class _RectObjClass : public _ObjectClass {
 protected:
   _RectObjClass() {}

   virtual WidgetClass classPointer() { return rectObjClass; }
   virtual _XtString className() { return (_XtString) "RectObj"; }
 public:
   /* resources */
   Boolean ancestorSensitive() const;
   void borderWidth(Dimension);
   Dimension borderWidth() const;
   Dimension height() const;
   void height(Dimension);
   void sensitive(Boolean cond);
   Boolean sensitive() const;
   Dimension width() const;
   void width(Dimension);
   Position x() const;
   void x(Position xpos);
   Position y() const;
   void y(Position ypos);

   /* extra */
   void disable() { sensitive(FALSE); }
   void enable() { sensitive(TRUE); }
};

#endif
