/* $Id: MessageB.h,v 1.4 1999/02/03 13:50:21 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_MESSAGEB_H_)
#define _XARM_MESSAGEB_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/BulletinB.h>

class MessageBoxClass : public BulletinBoardClass {
 protected:
   MessageBoxClass() {}
   virtual WidgetClass classPointer() { return xmMessageBoxWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmMessageBox"; }
 public:
   /* convenience rountines */
   Widget getChild(unsigned char);

   /* callbacks */
   void cancelCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void okCallback(XtCallbackProc funcp, XtPointer data = NULL);

   /* resources */
   void cancelLabelString(const char *);
   char *cancelLabelString() const;
   void helpLabelString(const char *);
   char *helpLabelString() const;
   void defaultButtonType(unsigned char);
   unsigned char defaultButtonType() const;
   void dialogType(unsigned char);
   unsigned char dialogType() const;
   void messageAlignment(unsigned char);
   unsigned char messageAlignment() const;
   void messageString(const char *);
   char * messageString() const;
   void minimizeButtons(Boolean);
   Boolean minimizeButtons() const;
   void okLabelString(const char *);
   char *okLabelString() const;
   void symbolPixmap(Pixmap);
   Pixmap symbolPixmap() const;
};

class MessageBox : public MessageBoxClass {
 protected:
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   MessageBox(Widget w_parent,char *str, _XtString name = NULL);
   MessageBox(Widget w_parent,
              ArgList arglist = NULL,
              Cardinal cnt = 0,
              _XtString name = NULL);
   MessageBox(_XtString name, Widget w_parent);
   MessageBox(Widget w_parent, XarmArg &args, _XtString name);
};

class MessageDialog : public MessageBoxClass {
 protected:
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   MessageDialog(Widget w_parent,char *str, _XtString name = NULL);
   MessageDialog(Widget w_parent,
                 ArgList arglist = NULL, 
                 Cardinal cnt = 0,
                 _XtString name = NULL);
   MessageDialog(_XtString name, Widget w_parent);
   MessageDialog(Widget w_parent, XarmArg &args, _XtString name);
};

class QuestionDialog : public MessageBoxClass {
 protected:
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   QuestionDialog(Widget w_parent, char *mesg, _XtString name = NULL);
   QuestionDialog(Widget w_parent,
                  ArgList arglist = NULL, 
                  Cardinal cnt = 0,
                  _XtString name = NULL);
   QuestionDialog(_XtString name, Widget w_parent);
   QuestionDialog(Widget w_parent, XarmArg &args, _XtString name);
};

class InformationDialog : public MessageBoxClass { 
 protected:
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   InformationDialog(Widget w_parent, char *mesg, _XtString name = NULL);
   InformationDialog(Widget w_parent, 
                     ArgList arglist = NULL,
                     Cardinal cnt = 0,
                     _XtString name = NULL);
   InformationDialog(_XtString name, Widget w_parent);
   InformationDialog(Widget w_parent, XarmArg &args, _XtString name);
};

class ErrorDialog : public MessageBoxClass { 
 protected:
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   ErrorDialog(Widget w_parent, char *mesg, _XtString name = NULL);
   ErrorDialog(Widget w_parent,
               ArgList arglist = NULL,
               Cardinal cnt = 0,
               _XtString name = NULL);
   ErrorDialog(_XtString name, Widget w_parent);
   ErrorDialog(Widget w_parent, XarmArg &args, _XtString name);
};

class WarningDialog : public MessageBoxClass { 
 protected:
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   WarningDialog(Widget w_parent, char *mesg, _XtString name = NULL);
   WarningDialog(Widget w_parent,
                 ArgList arglist = NULL,
                 Cardinal cnt = 0,
                 _XtString name = NULL);
   WarningDialog(_XtString name, Widget w_parent);
   WarningDialog(Widget w_parent, XarmArg &args, _XtString name);
};

class WorkingDialog : public MessageBoxClass { 
 protected:
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   WorkingDialog(Widget w_parent, char *mesg, _XtString name = NULL);
   WorkingDialog(Widget w_parent,
                 ArgList arglist = NULL,
                 Cardinal cnt = 0,
                 _XtString name = NULL);
   WorkingDialog(_XtString name, Widget w_parent);
   WorkingDialog(Widget w_parent, XarmArg &args, _XtString name);
};


#endif
