/*
 Copyright (C) 1997 Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xm/SpinB.h>
#include <Xarm/Manager.h>

class SpinBoxClass : public ManagerClass {
 protected:
   SpinBoxClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer() { return xmSpinBoxWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmSpinBox"; }
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   /* callbacks */
   void modifyVerifyCallback(XtCallbackProc fp, XtPointer udata = NULL);
   void valueChangedCallback(XtCallbackProc fp, XtPointer udata = NULL);

   /* resources */

   void arrowLayout(unsigned char);
   unsigned char arrowLayout() const;
   void arrowSize(Dimension);
   Dimension arrowSize() const;
   void defaultArrowSensitivity(unsigned char);
   unsigned char defaultArrowSensitivity() const;
   void detailShadowThickness(Dimension);
   Dimension detailShadowThickness() const;
   void initialDelay(unsigned int);
   unsigned int initialDelay() const;
   void marginHeight(Dimension);
   Dimension marginHeight() const;
   void marginWidth(Dimension);
   Dimension marginWidth() const;
   void repeatDelay(unsigned int);
   unsigned int repeatDelay() const;
   void spacing(Dimension);
   Dimension spacing() const;
   void arrowSensitivity(unsigned char);
   unsigned char arrowSensitivity() const;

   // In the Motif 2.0 version of the SpinBox, the following
   // resources are set on each child of the spinbox. Therefore
   // we must pass the child widget as a parameter.

   void decimalPoints(Widget, short);
   short decimalPoints(Widget) const;
   void incrementValue(Widget, int);
   int incrementValue(Widget) const;
   void maximumValue(Widget, int);
   int maximumValue(Widget) const;
   void minimumValue(Widget, int);
   int minimumValue(Widget) const;
   void numValues(Widget, int);
   int numValues(Widget) const;
   void position(Widget, int);
   int position(Widget) const;
   unsigned char spinBoxChildType(Widget) const;
   void values(Widget, const XmStringTable);
   XmStringTable values(Widget) const;

   /* Extra functionality */
   void values(Widget, const char **, const int c);
};

class SpinBox : public SpinBoxClass {

 public:
   SpinBox(Widget p, 
            ArgList arglist = NULL, 
            Cardinal cnt = 0, 
            _XtString name = NULL); 
   SpinBox(_XtString name, Widget p);
   SpinBox(Widget w_parent, XarmArg &args, _XtString name);
};
