/* $Id: List.h,v 1.5 1999/02/03 13:50:21 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_LIST_H_)
#define _XARM_LIST_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Primitive.h>

class ListClass : public PrimitiveClass {
 protected:
   ListClass() {} 
   virtual WidgetClass classPointer() { return xmListWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmList"; }
 public:
   /* callbacks */
   void browseSelectionCallback(XtCallbackProc, XtPointer);
   void defaultActionCallback(XtCallbackProc, XtPointer);
   void extendedSelectionCallback(XtCallbackProc, XtPointer);
   void multipleSelectionCallback(XtCallbackProc, XtPointer);
   void singleSelectionCallback(XtCallbackProc, XtPointer);

   /* convenience routines */

   /* resources */
   void automaticSelection(Boolean);
   Boolean automaticSelection() const;
   void doubleClickInterval(int);
   int doubleClickInterval() const;
   void fontList(const XmFontList);
   XmFontList fontList() const;
   void itemCount(int);
   int itemCount() const;
   void items(const XmStringTable);
   XmStringTable items() const;
   void listMarginHeight(Dimension);
   Dimension listMarginHeight() const;
   void listMarginWidth(Dimension);
   Dimension listMarginWidth() const;
   unsigned char listSizePolicy() const;
   void listSpacing(Dimension);
   Dimension listSpacing() const;
   void scrollBarDisplayPolicy(unsigned char);
   unsigned char scrollBarDisplayPolicy() const;
   void selectedItemCount(int);
   int selectedItemCount() const; 
   void selectedItems(const XmStringTable);
   XmStringTable selectedItems() const;
   void selectionPolicy(unsigned char);
   unsigned char selectionPolicy() const;
   void stringDirection(XmStringDirection);
   XmStringDirection stringDirection() const;
   void topItemPosition(int);
   int topItemPosition() const;
   void visibleItemCount(int);
   int visibleItemCount() const;

   /* extra functionality */
   void add(const char *);  /* adds an item to the list box */
   void add(const char ** l, int c); /* [][]= { "foo","yo" }; */
   void clear();     /* clears out the list box */
   int count() const;      /* returns the count of the items in the list */
   void del(int);     /* deletes an item at position p */
   void del(int n,int p); /* deletes n items starting at position p */
   void del(const char *);
   void del(const char **, int); /* [][]= { "foo","yo" }; */
   void deselect(const char *);
   void deselect(int);
   void deselectAll();
   int exists(const char *); /* does the item exists in the list */
   void insert(const char * s, int p);  /* inserts an item at a location */
   void insert(const char ** l, int c, int p); /* [][]= {"foo","yo" }; */
   int item(const char *s); /* returns the position of s */
   void horizontal(int); /* position of the scroll bar */
   int match(const char *item, int *&p, int &c); 
   void replace(const char **n, int c, int p);
   void replace(const char **o, int c, const char **n); /* replace old items w/ new */
   Boolean selected(int *&, int &);  /* returns the selected items, delete array */
   void select(const char *s, int notify); /* selects the item in the list */
   void select(int p, int notify); /* selects the item at that position */
   void set(const char *); /* sets the item to be the first visible item if posible */
   void set(int); /* sets the item to be the first visible item if posible */
   void setBottom(const char *);
   void setBottom(int);
   
};

class List : public ListClass {
 public:
   List(Widget w_parent,
        ArgList arglist = NULL,
        Cardinal = 0,
        _XtString name = NULL);
   List(_XtString name, Widget w_parent);
   List(Widget w_parent, XarmArg &args, _XtString name);
};

class ScrolledList : public ListClass {
 protected:
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   ScrolledList(Widget w_parent,
        ArgList arglist = NULL,
        Cardinal = 0,
        _XtString name = NULL);
  ScrolledList(_XtString name, Widget w_parent);
  ScrolledList(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
