/* $Id: Gauge.h,v 1.2 1999/01/15 10:16:39 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_GAUGE_H_)
#define _XARM_GAUGE_H_

/*
 * Warning:  These classes diverge from the Motif 1.2 standard GUI.
 */

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Primitive.h>
#include <Xmext/Gauge.h>

class GaugeClass : public PrimitiveClass {
 protected:
   GaugeClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer() { return xmGaugeWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmGauge"; }
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   /* resources */
   void          gaugeMargin(int);
   int           gaugeMargin() const;
   void          fill(Boolean);
   Boolean       fill() const;
   void          maximum(int);
   int           maximum() const;
   void          minimum(int);
   int           minimum() const;
   void          orientation(unsigned char);
   unsigned char orientation() const;
   void          processingDirection(unsigned char);
   unsigned char processingDirection() const;
   void          showMinMax(Boolean);
   Boolean       showMinMax() const;
   void          showPercentage(Boolean);
   Boolean       showPercentage() const;
   void          showValue(Boolean);
   Boolean       showValue() const; 
#if 1 
   // Default mechanism needs fixing
   void          sliderColor(Pixel);
   void          sliderColor(const char *);
   Pixel         sliderColor() const;
#endif
   void          sliderShadowThickness(int);
   int           sliderShadowThickness() const;
   void          sliderSize(int);
   int           sliderSize() const;   
   void          tickIncrement(int);
   int           tickIncrement() const;   
   void          troughColor(Pixel);
   void          troughColor(const char *);
   Pixel         troughColor() const;
   void          troughShadowThickness(int);
   int           troughShadowThickness() const;
   void          value(int);
   int           value() const; 
};

class Gauge : public GaugeClass {
 public:
   Gauge(Widget w_parent, 
               ArgList arglist = NULL, 
               Cardinal cnt = 0, 
               _XtString name = NULL);
   Gauge(_XtString name, Widget w_parent); 
   Gauge(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
