/* $Id: ConRes.h,v 1.2 1999/01/15 01:40:38 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_CONRES_H_)
#define _XARM_CONRES_H_

#include <Xarm/Base.h>

class FormConstraintResources : public WObjectClass { 
 protected:
   FormConstraintResources() {}
 public:
   /* constraint resources */
   void bottomAttachment(unsigned char);
   unsigned char bottomAttachment() const;
   void bottomOffset(int);
   int bottomOffset() const;
   void bottomPosition(int);
   int bottomPosition() const;
   void bottomWidget(Widget);
   Widget bottomWidget() const;
   void leftAttachment(unsigned char);
   unsigned char leftAttachment() const;
   void leftOffset(int);
   int leftOffset() const;
   void leftPosition(int);
   int leftPosition() const;
   void leftWidget(Widget);
   Widget leftWidget() const;
   void resizable(Boolean); 
   Boolean resizable() const; 
   void rightAttachment(unsigned char);
   unsigned char rightAttachment() const;
   void rightOffset(int);
   int rightOffset() const;
   void rightPosition(int);
   int rightPosition() const;
   void rightWidget(Widget);
   Widget rightWidget() const;
   void topAttachment(unsigned char);
   unsigned char topAttachment() const;
   void topOffset(int);
   int topOffset() const;
   void topPosition(int);
   int topPosition() const;
   void topWidget(Widget);
   Widget topWidget() const; 

};

class FrameConstraintResources : public FormConstraintResources { 
 protected:
   FrameConstraintResources() {}
 public:
   /* constraint resources */
   void childType(unsigned char);
   unsigned char childType() const;
   void childHorizontalAlignment(unsigned char);
   unsigned char childHorizontalAlignment() const;
   void childHorizontalSpacing(unsigned char);
   unsigned char childHorizontalSpacing() const;
   void childVerticalAlignment(unsigned char);
   unsigned char childVerticalAlignment() const;
};

class PanedWindowConstraintResources : public FrameConstraintResources {
 protected:
   PanedWindowConstraintResources() {}
 public:
   /* constraints */
   void allowResize(Boolean);
   Boolean allowResize() const;
   void paneMaximum(Dimension);
   Dimension paneMaximum() const;
   void paneMinimum(Dimension);
   Dimension paneMinimum() const;
   void positionIndex(short);
   short positionIndex() const;
   void skipAdjust(Boolean);
   Boolean skipAdjust() const;
};

class RowColumnConstraintResources : public PanedWindowConstraintResources {
 protected:
   RowColumnConstraintResources() {}
 public:
   /* constraint resources */
   void positionIndex(short s);
   short positionIndex() const;
};

class ConstraintResources : public RowColumnConstraintResources {
 protected:
   ConstraintResources() {}
};

#endif
