/* $Id: CDEComboBox.h,v 1.4 1999/01/15 00:53:19 glgay Exp $ */
/*
 Copyright (C) 1997 Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Dt/ComboBox.h>

class ComboBoxClass : public ManagerClass {
 protected:
   ComboBoxClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer() { return dtComboBoxWidgetClass; }
   virtual _XtString className() { return (_XtString) "DtComboBox"; }
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   /* callbacks */
   void selectionCallback(XtCallbackProc fp, XtPointer udata = NULL);

   /* resources */
   unsigned char comboBoxType() const;  /* read only resource after construction */
   void marginHeight(Dimension);
   Dimension marginHeight() const;
   void marginWidth(Dimension);
   Dimension marginWidth() const;
   void selectedItem(const char *); /* notice this takes char * not XmString */
   char *selectedItem() const; /* notice this returns char * not XmString */
   void selectedPosition(int);
   int selectedPosition() const;

   /* convenience routines */
   Widget list() const;    /* return list widget */

   /* CDE ComboBox functions */
   void add(const char *str, int pos = 0, Boolean unique = False);
   void del(int);
   void setItem(const char *);

   /* The clear function was added by popular demand. */
   void clear();     /* Clear the list */
   
   /* extra functionality */
   /* 
    * listObject()
    * This routine returns the list wrapper object for the list widget. 
    */
   ListClass *listObject() const; 
   
};

class ComboBox : public ComboBoxClass {
 public:
   ComboBox(Widget p, 
            ArgList arglist = NULL, 
            Cardinal cnt = 0, 
            _XtString name = NULL); 
   ComboBox(_XtString name, Widget p);
   ComboBox(Widget w_parent, XarmArg &args, _XtString name);
};

