/* $Id: BulletinB.h,v 1.3 1999/01/14 03:35:18 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_BULLETINB_H_)
#define _XARM_BULLETINB_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Manager.h>

class BulletinBoardClass : public ManagerClass {
 protected:
   BulletinBoardClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer() { return xmBulletinBoardWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmBulletinBoard"; }
 public:
   /* callbacks */
   void focusCallback(XtCallbackProc fp, XtPointer udata = NULL);
   void mapCallback(XtCallbackProc fp, XtPointer udata = NULL);
   void unmapCallback(XtCallbackProc fp, XtPointer udata = NULL);

   /* resources */
   void allowOverlap(Boolean);
   Boolean allowOverlap() const;
   Boolean autoUnmanage() const;
   void buttonFontList(XmFontList);
   XmFontList buttonFontList() const;
   void cancelButton(Widget);
   Widget cancelButton() const;
   void defaultButton(Widget);
   Widget defaultButton() const;
   void defaultPosition(Boolean);
   Boolean defaultPosition() const;
   void dialogStyle(unsigned char);
   unsigned char dialogStyle() const;
   void dialogTitle(const char *str);
   char *dialogTitle() const;
   void labelFontList(XmFontList);
   XmFontList labelFontList() const;
   void marginHeight(Dimension);
   Dimension marginHeight() const;
   void marginWidth(Dimension);
   Dimension marginWidth() const;
   void noResize(Boolean);
   Boolean noResize() const;
   void resizePolicy(unsigned char);
   unsigned char resizePolicy() const;
   void shadowType(unsigned char);
   unsigned char shadowType() const;
   void textFontList(XmFontList);
   XmFontList textFontList() const;

};

class BulletinBoard : public BulletinBoardClass {
 public:
   BulletinBoard(Widget p, 
                 ArgList arglist = NULL, 
                 Cardinal cnt = 0, 
                 _XtString name = NULL); 
   BulletinBoard(_XtString name, Widget p);
   BulletinBoard(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
